/*
 * Decompiled with CFR 0.152.
 */
package org.aludratest.hpalm.service.impl;

import java.io.IOException;
import java.util.List;
import org.aludratest.exception.AccessFailure;
import org.aludratest.exception.AutomationException;
import org.aludratest.hpalm.entity.Entity;
import org.aludratest.hpalm.infrastructure.EntityCollection;
import org.aludratest.hpalm.infrastructure.HpAlmException;
import org.aludratest.hpalm.infrastructure.HpAlmSession;
import org.aludratest.hpalm.infrastructure.ServerTime;
import org.aludratest.hpalm.service.EntityType;
import org.aludratest.hpalm.service.HpAlmInteraction;
import org.aludratest.service.Interaction;
import org.aludratest.service.SystemConnector;
import org.aludratest.testcase.event.attachment.Attachment;

public class HpAlmInteractionImpl
implements Interaction,
HpAlmInteraction {
    private HpAlmSession session;

    public HpAlmInteractionImpl(HpAlmSession session) {
        this.session = session;
    }

    @Override
    public ServerTime getServerTime() {
        try {
            return this.session.getServerTime();
        }
        catch (IOException e) {
            throw new AccessFailure("Could not retrieve server time", (Throwable)e);
        }
        catch (HpAlmException e) {
            throw new AutomationException("Could not retrieve server time", (Throwable)e);
        }
    }

    @Override
    public EntityCollection getAllEntities(EntityType entityType) {
        try {
            return this.session.queryEntities(entityType.getHpAlmTypeName(), null);
        }
        catch (IOException e) {
            throw new AccessFailure("Could not query entity collection '" + entityType.getHpAlmTypeName() + "'", (Throwable)e);
        }
        catch (HpAlmException e) {
            throw new AutomationException("Could not query entity collection '" + entityType.getHpAlmTypeName() + "'", (Throwable)e);
        }
    }

    @Override
    public Entity getSingleEntity(EntityType entityType, long id) {
        try {
            return this.session.getEntity(entityType.getHpAlmTypeName(), id);
        }
        catch (IOException e) {
            throw new AccessFailure("Could not query " + (Object)((Object)entityType) + " #" + id, (Throwable)e);
        }
        catch (HpAlmException e) {
            throw new AutomationException("Could not query " + (Object)((Object)entityType) + " #" + id, (Throwable)e);
        }
    }

    @Override
    public Entity createEntity(EntityType entityType, Entity value) {
        try {
            value.setType(entityType.getHpAlmTypeName());
            return this.session.createEntity(value);
        }
        catch (IOException e) {
            throw new AccessFailure("Could not create entity of type " + (Object)((Object)entityType), (Throwable)e);
        }
        catch (HpAlmException e) {
            throw new AutomationException("Could not create entity of type " + (Object)((Object)entityType), (Throwable)e);
        }
    }

    @Override
    public void updateEntity(EntityType entityType, long id, Entity value) {
        try {
            this.session.updateEntity(id, value);
        }
        catch (IOException e) {
            throw new AccessFailure("Could not update " + (Object)((Object)entityType) + " #" + id, (Throwable)e);
        }
        catch (HpAlmException e) {
            throw new AutomationException("Could not update " + (Object)((Object)entityType) + " #" + id, (Throwable)e);
        }
    }

    @Override
    public void deleteEntity(EntityType entityType, long id) {
        try {
            this.session.deleteEntity(entityType.getHpAlmTypeName(), id);
        }
        catch (IOException e) {
            throw new AccessFailure("Could not delete " + (Object)((Object)entityType) + " #" + id, (Throwable)e);
        }
        catch (HpAlmException e) {
            throw new AutomationException("Could not delete " + (Object)((Object)entityType) + " #" + id, (Throwable)e);
        }
    }

    @Override
    public EntityCollection queryEntities(EntityType entityType, String query) {
        try {
            return this.session.queryEntities(entityType.getHpAlmTypeName(), query);
        }
        catch (IOException e) {
            throw new AccessFailure("Could not query entities of type " + (Object)((Object)entityType), (Throwable)e);
        }
        catch (HpAlmException e) {
            throw new AutomationException("Could not query entities of type " + (Object)((Object)entityType), (Throwable)e);
        }
    }

    public List<Attachment> createDebugAttachments() {
        return null;
    }

    public List<Attachment> createAttachments(Object object, String title) {
        return null;
    }

    public void setSystemConnector(SystemConnector systemConnector) {
    }
}

