/*
 * Decompiled with CFR 0.152.
 */
package org.aludratest.maven.surefire;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.aludratest.AludraTest;
import org.aludratest.scheduler.RunnerListenerRegistry;
import org.aludratest.scheduler.node.RunnerLeaf;
import org.apache.maven.surefire.util.ReflectionUtils;

final class AludraTestReflectionUtil {
    private AludraTestReflectionUtil() {
    }

    public static Class<?> getAludraTestClass(ClassLoader classLoader, String className) {
        return ReflectionUtils.tryLoadClass((ClassLoader)classLoader, (String)className);
    }

    public static void runAludraTest(Object aludraTest, Class<?> testOrSuiteClass) throws InvocationTargetException {
        Method m = ReflectionUtils.getMethod((Object)aludraTest, (String)"run", (Class[])new Class[]{Class.class});
        try {
            m.invoke(aludraTest, testOrSuiteClass);
        }
        catch (InvocationTargetException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InvocationTargetException(e);
        }
    }

    public static void registerRunnerListener(Object runnerListener, Object aludraTest, Class<?> runnerListenerClass) throws InvocationTargetException {
        Object runnerListenerRegistry = AludraTestReflectionUtil.getImplementorInstance(aludraTest, RunnerListenerRegistry.ROLE);
        ReflectionUtils.invokeSetter((Object)runnerListenerRegistry, (String)"addRunnerListener", runnerListenerClass, (Object)runnerListener);
    }

    public static Object startFramework(ClassLoader classLoader) throws InvocationTargetException {
        try {
            Class<?> clazz = classLoader.loadClass(AludraTest.class.getName());
            return clazz.getMethod("startFramework", new Class[0]).invoke(null, new Object[0]);
        }
        catch (InvocationTargetException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InvocationTargetException(e);
        }
    }

    private static Object getImplementorInstance(Object aludraTest, String className) throws InvocationTargetException {
        try {
            Object serviceManager = ReflectionUtils.invokeGetter((Object)aludraTest, (String)"getServiceManager");
            Method m = ReflectionUtils.getMethod((Object)serviceManager, (String)"newImplementorInstance", (Class[])new Class[]{Class.class});
            return m.invoke(serviceManager, serviceManager.getClass().getClassLoader().loadClass(className));
        }
        catch (InvocationTargetException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InvocationTargetException(e);
        }
    }

    public static void stopFramework(Object aludraTest) throws InvocationTargetException {
        try {
            ReflectionUtils.getMethod((Object)aludraTest, (String)"stopFramework", (Class[])new Class[0]).invoke(aludraTest, new Object[0]);
        }
        catch (InvocationTargetException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InvocationTargetException(e);
        }
    }

    public static String getTestClassName(Object runnerLeaf) {
        Object testInvoker = ReflectionUtils.invokeGetter((Object)runnerLeaf, (String)"getTestInvoker");
        Class testClass = (Class)ReflectionUtils.invokeGetter((Object)testInvoker, (String)"getTestClass");
        return testClass.getName();
    }

    public static String getName(Object runnerGroupOrLeaf) {
        return (String)ReflectionUtils.invokeGetter((Object)runnerGroupOrLeaf, (String)"getName");
    }

    public static String getRootName(Object runnerTree) {
        return AludraTestReflectionUtil.getName(ReflectionUtils.invokeGetter((Object)runnerTree, (String)"getRoot"));
    }

    public static boolean groupContainsLeafs(Object runnerGroup) {
        Iterable ls = (Iterable)ReflectionUtils.invokeGetter((Object)runnerGroup, (String)"getChildren");
        for (Object o : ls) {
            if (o == null || !o.getClass().getName().equals(RunnerLeaf.class.getName())) continue;
            return true;
        }
        return false;
    }

    public static String getParentName(Object runnerGroup) {
        Object parent = ReflectionUtils.invokeGetter((Object)runnerGroup, (String)"getParent");
        return parent == null ? AludraTestReflectionUtil.getName(runnerGroup) : AludraTestReflectionUtil.getName(parent);
    }

    public static boolean isIgnored(Object runnerLeaf) {
        try {
            Method m = runnerLeaf.getClass().getMethod("getAttribute", String.class);
            Boolean value = (Boolean)m.invoke(runnerLeaf, "IGNORE");
            return value != null && Boolean.TRUE.equals(value);
        }
        catch (Throwable t) {
            return false;
        }
    }
}

