/*
 * Decompiled with CFR 0.152.
 */
package org.aludratest.maven.surefire;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.aludratest.maven.surefire.AludraTestReflectionUtil;
import org.aludratest.testcase.TestStatus;
import org.apache.maven.surefire.report.CategorizedReportEntry;
import org.apache.maven.surefire.report.PojoStackTraceWriter;
import org.apache.maven.surefire.report.ReportEntry;
import org.apache.maven.surefire.report.RunListener;
import org.apache.maven.surefire.report.SimpleReportEntry;
import org.apache.maven.surefire.report.StackTraceWriter;
import org.apache.maven.surefire.suite.RunResult;
import org.apache.maven.surefire.util.ReflectionUtils;

public class AludraTestReportListener
implements InvocationHandler {
    private AtomicInteger testsRun = new AtomicInteger();
    private AtomicInteger testsSkipped = new AtomicInteger();
    private AtomicInteger testsFailed = new AtomicInteger();
    private AtomicInteger testErrors = new AtomicInteger();
    private Map<Object, TestStatus> testStates = new HashMap<Object, TestStatus>();
    private Map<Object, Long> testStartTimes = new HashMap<Object, Long>();
    private Map<Object, Throwable> testThrowables = new HashMap<Object, Throwable>();
    private RunListener reporter;

    public AludraTestReportListener(RunListener reporter) {
        this.reporter = reporter;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        if ("startingTestProcess".equals(methodName)) {
            this.handleStartingTestProcess(args[0]);
        }
        if ("startingTestGroup".equals(methodName)) {
            this.handleStartingRunnerGroup(args[0]);
        }
        if ("startingTestLeaf".equals(methodName)) {
            this.handleStartingRunnerLeaf(args[0]);
        }
        if ("finishedTestLeaf".equals(methodName)) {
            this.handleFinishedRunnerLeaf(args[0]);
        }
        if ("finishedTestGroup".equals(methodName)) {
            this.handleFinishedRunnerGroup(args[0]);
        }
        if ("finishedTestProcess".equals(methodName)) {
            this.handleFinishedTestProcess(args[0]);
        }
        if ("newTestStep".equals(methodName)) {
            this.handleTestStep(args[0], args[1]);
        }
        if ("equals".equals(methodName)) {
            return args[0] == proxy;
        }
        return null;
    }

    private void extractTestState(Object runnerLeaf, Object testStepInfo) throws Exception {
        TestStatus prevStatus;
        Object objStatus = testStepInfo.getClass().getMethod("getTestStatus", new Class[0]).invoke(testStepInfo, new Object[0]);
        TestStatus status = TestStatus.valueOf((String)objStatus.toString());
        if (this.isWorseThan(status, prevStatus = this.testStates.get(runnerLeaf))) {
            this.testStates.put(runnerLeaf, status);
        }
    }

    private boolean isWorseThan(TestStatus status1, TestStatus status2) {
        if (status2 == null || status2 == TestStatus.IGNORED) {
            return true;
        }
        if (status2 == TestStatus.PASSED) {
            return status1.isFailure();
        }
        if (status2 == TestStatus.FAILED || status2 == TestStatus.FAILEDPERFORMANCE) {
            return status1.isFailure() && status1 != TestStatus.FAILED && status1 != TestStatus.FAILEDPERFORMANCE;
        }
        return false;
    }

    public RunResult createRunResult() {
        return new RunResult(this.testsRun.get(), this.testErrors.get(), this.testsFailed.get(), this.testsSkipped.get());
    }

    private String getSourceName(Object runnerLeaf) {
        return AludraTestReflectionUtil.getTestClassName(runnerLeaf);
    }

    private String getTestName(Object runnerLeaf) {
        return AludraTestReflectionUtil.getName(runnerLeaf);
    }

    private void handleStartingTestProcess(Object runnerTree) {
    }

    private void handleStartingRunnerGroup(Object runnerGroup) {
        if (AludraTestReflectionUtil.groupContainsLeafs(runnerGroup)) {
            SimpleReportEntry entry = new SimpleReportEntry(AludraTestReflectionUtil.getParentName(runnerGroup), AludraTestReflectionUtil.getName(runnerGroup));
            this.reporter.testSetStarting((ReportEntry)entry);
        }
    }

    private void handleStartingRunnerLeaf(Object runnerLeaf) {
        this.testStartTimes.put(runnerLeaf, System.currentTimeMillis());
        boolean ignored = AludraTestReflectionUtil.isIgnored(runnerLeaf);
        if (ignored) {
            return;
        }
        CategorizedReportEntry entry = new CategorizedReportEntry(this.getSourceName(runnerLeaf), this.getTestName(runnerLeaf), null);
        this.reporter.testStarting((ReportEntry)entry);
    }

    private void handleFinishedRunnerLeaf(Object runnerLeaf) {
        this.testsRun.incrementAndGet();
        String sourceName = this.getSourceName(runnerLeaf);
        String name = this.getTestName(runnerLeaf);
        PojoStackTraceWriter stackTrace = null;
        Throwable t = this.testThrowables.get(runnerLeaf);
        if (t != null) {
            stackTrace = new PojoStackTraceWriter(sourceName, name, t);
        }
        TestStatus status = this.testStates.get(runnerLeaf);
        if (AludraTestReflectionUtil.isIgnored(runnerLeaf)) {
            status = TestStatus.IGNORED;
        }
        if (status == null) {
            status = TestStatus.PASSED;
        }
        if (status.isFailure()) {
            SimpleReportEntry entry = CategorizedReportEntry.withException((String)sourceName, (String)name, (StackTraceWriter)stackTrace);
            if (status == TestStatus.FAILED || status == TestStatus.FAILEDPERFORMANCE) {
                this.testsFailed.incrementAndGet();
                this.reporter.testFailed((ReportEntry)entry);
            } else {
                this.testErrors.incrementAndGet();
                this.reporter.testError((ReportEntry)entry);
            }
        } else {
            Long startTime = this.testStartTimes.get(runnerLeaf);
            Integer elapsed = null;
            if (startTime != null) {
                elapsed = Long.valueOf(System.currentTimeMillis() - startTime).intValue();
            }
            CategorizedReportEntry entry = new CategorizedReportEntry(sourceName, sourceName, name, null, elapsed);
            if (status == TestStatus.IGNORED) {
                this.reporter.testSkipped((ReportEntry)entry);
            } else {
                this.reporter.testSucceeded((ReportEntry)entry);
            }
        }
    }

    private void handleFinishedRunnerGroup(Object runnerGroup) {
        if (AludraTestReflectionUtil.groupContainsLeafs(runnerGroup)) {
            SimpleReportEntry entry = new SimpleReportEntry(AludraTestReflectionUtil.getParentName(runnerGroup), AludraTestReflectionUtil.getName(runnerGroup));
            this.reporter.testSetCompleted((ReportEntry)entry);
        }
    }

    private void handleFinishedTestProcess(Object runnerTree) {
    }

    private void handleTestStep(Object runnerLeaf, Object testStep) throws Exception {
        this.extractTestState(runnerLeaf, testStep);
        Throwable t = (Throwable)ReflectionUtils.invokeGetter((Object)testStep, (String)"getError");
        if (t != null) {
            this.testThrowables.put(runnerLeaf, t);
        }
    }
}

