/*
 * Decompiled with CFR 0.152.
 */
package org.aludratest.maven.surefire;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import java.util.Iterator;
import org.aludratest.maven.surefire.AludraTestReflectionUtil;
import org.aludratest.maven.surefire.AludraTestReportListener;
import org.aludratest.maven.surefire.AludraTestTestChecker;
import org.aludratest.scheduler.RunnerListener;
import org.apache.commons.collections.IteratorUtils;
import org.apache.maven.surefire.providerapi.AbstractProvider;
import org.apache.maven.surefire.providerapi.ProviderParameters;
import org.apache.maven.surefire.report.ReporterException;
import org.apache.maven.surefire.report.ReporterFactory;
import org.apache.maven.surefire.report.RunListener;
import org.apache.maven.surefire.suite.RunResult;
import org.apache.maven.surefire.testset.TestRequest;
import org.apache.maven.surefire.testset.TestSetFailedException;
import org.apache.maven.surefire.util.ReflectionUtils;
import org.apache.maven.surefire.util.RunOrderCalculator;
import org.apache.maven.surefire.util.ScanResult;
import org.apache.maven.surefire.util.ScannerFilter;
import org.apache.maven.surefire.util.TestsToRun;

public class AludraTestSurefireProvider
extends AbstractProvider {
    private ClassLoader testClassLoader;
    private ScanResult scanResult;
    private RunOrderCalculator runOrderCalculator;
    private AludraTestTestChecker scannerFilter;
    private final TestRequest testRequest;
    private TestsToRun testsToRun;
    private ReporterFactory reporterFactory;

    public AludraTestSurefireProvider(ProviderParameters providerParameters) {
        this.testClassLoader = providerParameters.getTestClassLoader();
        this.scanResult = providerParameters.getScanResult();
        this.runOrderCalculator = providerParameters.getRunOrderCalculator();
        this.scannerFilter = new AludraTestTestChecker(this.testClassLoader);
        this.testRequest = providerParameters.getTestRequest();
        this.reporterFactory = providerParameters.getReporterFactory();
    }

    public Iterator getSuites() {
        return IteratorUtils.EMPTY_ITERATOR;
    }

    public RunResult invoke(Object forkTestSet) throws TestSetFailedException, ReporterException, InvocationTargetException {
        if (forkTestSet != null) {
            throw new IllegalArgumentException("AludraTest Surefire Provider does not expect forkTestSet parameter");
        }
        RunListener reporter = this.reporterFactory.createReporter();
        String directTest = this.testRequest.getRequestedTest();
        String directTestMethod = this.testRequest.getRequestedTestMethod();
        if (directTest != null) {
            directTest = directTest.trim();
            while (directTest.endsWith(",")) {
                directTest = directTest.substring(0, directTest.length() - 1);
                directTest = directTest.trim();
            }
            Class classToTest = ReflectionUtils.tryLoadClass((ClassLoader)this.testClassLoader, (String)directTest);
            if (classToTest == null) {
                throw new IllegalArgumentException("Class " + directTest + " not found in test scope");
            }
            Object aludraTest = AludraTestReflectionUtil.startFramework(this.testClassLoader);
            try {
                Class<?> runnerListenerClass = this.testClassLoader.loadClass(RunnerListener.class.getName());
                AludraTestReportListener reportListener = new AludraTestReportListener(reporter);
                Object runnerListenerProxy = Proxy.newProxyInstance(this.testClassLoader, new Class[]{runnerListenerClass}, (InvocationHandler)reportListener);
                AludraTestReflectionUtil.registerRunnerListener(runnerListenerProxy, aludraTest, runnerListenerClass);
                AludraTestReflectionUtil.runAludraTest(aludraTest, classToTest);
                RunResult runResult = reportListener.createRunResult();
                return runResult;
            }
            catch (ClassNotFoundException e) {
                throw new InvocationTargetException(e);
            }
            finally {
                AludraTestReflectionUtil.stopFramework(aludraTest);
            }
        }
        if (directTestMethod != null) {
            throw new TestSetFailedException("Running AludraTest test methods currently not supported (" + directTestMethod + " cannot be executed)");
        }
        if (this.testsToRun == null) {
            this.testsToRun = this.scanClassPath();
        }
        throw new TestSetFailedException("Running multiple AludraTest test classes currently not supported. Please use -Dtest=<testOrSuiteClass>");
    }

    private TestsToRun scanClassPath() {
        TestsToRun scanned = this.scanResult.applyFilter((ScannerFilter)this.scannerFilter, this.testClassLoader);
        return this.runOrderCalculator.orderTestClasses(scanned);
    }
}

