/*
 * Decompiled with CFR 0.152.
 */
package org.aludratest.maven.surefire;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.aludratest.maven.surefire.AludraTestReflectionUtil;
import org.aludratest.testcase.AludraTestCase;
import org.aludratest.testcase.Test;
import org.apache.maven.surefire.util.ScannerFilter;

public class AludraTestTestChecker
implements ScannerFilter {
    private final Class<?> aludraTestCaseClass;
    private final Class<?> testAnnotationClass;

    public AludraTestTestChecker(ClassLoader testClassLoader) {
        this.aludraTestCaseClass = AludraTestReflectionUtil.getAludraTestClass(testClassLoader, AludraTestCase.class.getName());
        this.testAnnotationClass = AludraTestReflectionUtil.getAludraTestClass(testClassLoader, Test.class.getName());
    }

    public boolean accept(Class testClass) {
        return this.isValidAludraTestClass(testClass);
    }

    public boolean isValidAludraTestClass(Class<?> testClass) {
        if (this.aludraTestCaseClass != null && this.aludraTestCaseClass.isAssignableFrom(testClass)) {
            for (Class<?> classToCheck = testClass; classToCheck != null; classToCheck = classToCheck.getSuperclass()) {
                if (!this.checkforTestAnnotatedMethod(classToCheck)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkforTestAnnotatedMethod(Class<?> testClass) {
        for (Method lMethod : testClass.getDeclaredMethods()) {
            for (Annotation lAnnotation : lMethod.getAnnotations()) {
                if (!this.testAnnotationClass.isAssignableFrom(lAnnotation.annotationType())) continue;
                return true;
            }
        }
        return false;
    }
}

