package org.amshove.kluent.internal

import kotlin.reflect.KClass

/** Asserts that a [blockResult] is a failure with the specific exception type being thrown. */
@PublishedApi
internal actual fun <T : Throwable> checkResultIsFailure(exceptionClass: KClass<T>, message: String?, blockResult: Result<Unit>): T {
    blockResult.fold(
            onSuccess = {
                val msg = messagePrefix(message)
                fail(msg + "Expected an exception of ${exceptionClass.java} to be thrown, but was completed successfully.")
            },
            onFailure = { e ->
                if (exceptionClass.java.isInstance(e)) {
                    @Suppress("UNCHECKED_CAST")
                    return e as T
                }

                fail(messagePrefix(message) + "Expected an exception of ${exceptionClass.java} to be thrown, but was $e")
            }
    )
}