/*
 * Decompiled with CFR 0.152.
 */
package org.anadix.html;

import java.math.BigInteger;
import org.anadix.Element;
import org.anadix.html.Attributes;
import org.anadix.html.Position;

public abstract class HtmlElement
implements Element,
Comparable<HtmlElement> {
    private final BigInteger id;
    private final String name;
    private final HtmlElement parent;
    private final Attributes attributes;
    private Position position;
    private String source;
    private String textContent;

    HtmlElement(BigInteger id, String name, HtmlElement parent, Attributes attributes) {
        this(id, name, parent, attributes, null, null, null);
    }

    private HtmlElement(BigInteger id, String name, HtmlElement parent, Attributes attributes, String source, Position position, String textContent) {
        if (id == null) {
            throw new NullPointerException("id can't be null");
        }
        if (name == null || name.length() < 1) {
            throw new NullPointerException("name can't be null");
        }
        if (attributes == null) {
            throw new NullPointerException("atributes can't be null");
        }
        this.id = id;
        this.name = name;
        this.parent = parent;
        this.attributes = attributes;
        this.source = source;
        this.position = position;
        this.textContent = textContent;
    }

    public BigInteger getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public HtmlElement getParent() {
        return this.parent;
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    public String getAttribute(String name) {
        return this.getAttributes().getAttribute(name);
    }

    public void setSource(String source) {
        if (source == null || source.length() == 0) {
            throw new NullPointerException("source can't be null");
        }
        this.source = source;
    }

    public String getSource() {
        return this.source;
    }

    public void setPosition(Position position) {
        if (position == null) {
            throw new NullPointerException("position can't be null");
        }
        this.position = position;
    }

    public Position getPosition() {
        return this.position;
    }

    public String getTextContent() {
        return this.textContent;
    }

    public void setTextContent(String textContent) {
        if (textContent == null || textContent.length() == 0) {
            throw new NullPointerException("text content can't be null");
        }
        this.textContent = textContent;
    }

    @Override
    public int compareTo(HtmlElement o) {
        return this.getId().compareTo(o.getId());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HtmlElement other = (HtmlElement)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        return String.format("%s[id='%s', position='%s', attributes='%s', source='%s']", this.name, this.id, this.position, this.attributes, this.source);
    }
}

