/*
 * Decompiled with CFR 0.152.
 */
package org.anadix.html;

import java.util.Collection;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.logging.Logger;

public class Attributes {
    private final Properties attributes;

    public Attributes(Properties attributes) {
        if (attributes == null) {
            throw new NullPointerException("attributes can't be null");
        }
        this.attributes = new Properties();
        for (String key : attributes.stringPropertyNames()) {
            this.attributes.setProperty(key, attributes.getProperty(key));
        }
        if (this.hasAttribute("style")) {
            Properties style = Attributes.parseStyle(this.getAttribute("style"));
            for (String key : style.stringPropertyNames()) {
                this.attributes.setProperty(key, style.getProperty(key));
            }
        }
    }

    public String getAttribute(String key) {
        return this.attributes.getProperty(key);
    }

    public String getAttribute(String key, String defaultValue) {
        return this.attributes.getProperty(key, defaultValue);
    }

    public boolean hasAttribute(String key) {
        return this.attributes.containsKey(key);
    }

    public Collection<String> getAvaliableAttributes() {
        return this.attributes.stringPropertyNames();
    }

    public static Properties parseStyle(String style) {
        Properties result = new Properties();
        style = style.replace("\r", "").replace("\n", "").replace("\t", "");
        Pattern p = Pattern.compile("[^:;]+:([^;\"]|\"[^\"]+\")*;?");
        Matcher m = p.matcher(style);
        while (m.find()) {
            String[] split;
            String prop = m.group().trim();
            if (prop.endsWith(";")) {
                prop = prop.substring(0, prop.length() - 1);
            }
            if ((split = prop.split(":")).length < 2) {
                Logger.getLogger(Attributes.class).warnf("CSS property without value: '%s'", (Object)prop);
                continue;
            }
            result.setProperty(split[0].trim(), split[1].trim());
        }
        return result;
    }

    public String toString() {
        return this.attributes.toString();
    }
}

