/*
 * Decompiled with CFR 0.152.
 */
package org.anadix.html;

public class Position {
    private final int characterNumber;
    private final int lineNumber;
    private final int columnNumber;

    public Position(int characterNumber) {
        this(characterNumber, -1, -1);
    }

    public Position(int lineNumber, int columnNumber) {
        this(-1, lineNumber, columnNumber);
    }

    private Position(int characterNumber, int lineNumber, int columnNumber) {
        this.characterNumber = characterNumber;
        this.lineNumber = lineNumber;
        this.columnNumber = columnNumber;
    }

    public int getCharacterNumber() {
        return this.characterNumber;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public int hashCode() {
        int prime = 2011;
        int result = 1;
        result = 2011 * result + this.characterNumber;
        result = 2011 * result + this.columnNumber;
        result = 2011 * result + this.lineNumber;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Position other = (Position)obj;
        if (this.characterNumber != other.characterNumber) {
            return false;
        }
        if (this.columnNumber != other.columnNumber) {
            return false;
        }
        return this.lineNumber == other.lineNumber;
    }

    public String toString() {
        if (this.characterNumber > 0) {
            return Integer.toString(this.characterNumber);
        }
        return String.format("[%s, %s]", this.lineNumber, this.columnNumber);
    }
}

