/*
 * Decompiled with CFR 0.152.
 */
package org.anadix.utils;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.anadix.Anadix;
import org.anadix.Analyzer;
import org.anadix.Report;
import org.anadix.Source;
import org.anadix.exceptions.SourceException;
import org.anadix.factories.SourceFactory;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.MatchingTask;

public class AnalyzerAntTask
extends MatchingTask {
    private File sourcesDir = new File("src");

    public void setParserClass(String parserClass) {
        if (!Anadix.setDefaultParser((String)parserClass)) {
            this.log("Unable to set parser class " + parserClass, 0);
        }
    }

    public void setConditionSetClass(String conditionSetClass) {
        if (!Anadix.setDefaultParser((String)conditionSetClass)) {
            this.log("Unable to set condition set class " + conditionSetClass, 0);
        }
    }

    public void setFormatterClass(String formatterClass) {
        if (!Anadix.setDefaultParser((String)formatterClass)) {
            this.log("Unable to set formatter class " + formatterClass, 0);
        }
    }

    public void setSourcesDir(File dir) {
        this.sourcesDir = dir;
    }

    public void setReportsDir(File reportsDir) {
        if (!Anadix.setReportDirectory((File)reportsDir)) {
            this.log("Unable to set reports dir", 0);
        }
    }

    public void execute() throws BuildException {
        this.log("Starting...", 2);
        Analyzer a = this.createAnalyzer();
        this.log("Created an instance of analyzer", 2);
        Map<String, Report> results = this.analyze(a, this.sourcesDir);
        for (Map.Entry<String, Report> entry : results.entrySet()) {
            Anadix.formatReport((Report)entry.getValue(), (String)entry.getKey());
        }
    }

    private Analyzer createAnalyzer() throws BuildException {
        try {
            return Anadix.newAnalyzer();
        }
        catch (InstantiationException ex) {
            throw new BuildException("Unable to istantiate Analyzer " + ex, (Throwable)ex);
        }
    }

    private Map<String, Report> analyze(Analyzer analyzer, File file) {
        HashMap<String, Report> result = new HashMap<String, Report>();
        if (file.isDirectory()) {
            for (File child : file.listFiles()) {
                result.putAll(this.analyze(analyzer, child));
            }
        } else {
            this.log("Starting analysis of " + file, 3);
            String fileName = AnalyzerAntTask.getRelativePath(this.sourcesDir, file);
            if (fileName.contains(".") && fileName.lastIndexOf(46) > fileName.lastIndexOf(System.getProperty("path.separator"))) {
                fileName = fileName.substring(0, fileName.lastIndexOf(46));
            }
            result.put(fileName, this.analyzeFile(analyzer, file));
            this.log("Finished analysis of " + file, 3);
        }
        return result;
    }

    private Report analyzeFile(Analyzer analyzer, File file) {
        try {
            Source s = SourceFactory.newFileSource((File)file);
            return analyzer.analyze(s);
        }
        catch (SourceException ex) {
            throw new BuildException("Unable to create source", (Throwable)ex);
        }
    }

    private static String getRelativePath(File basedir, File file) {
        if (file.getAbsolutePath().contains(basedir.getAbsolutePath())) {
            return file.getAbsolutePath().substring(basedir.getAbsolutePath().length());
        }
        throw new RuntimeException(String.format("File %s not child of %s", file, basedir));
    }
}

