/*
 * Decompiled with CFR 0.152.
 */
package org.anadix.utils;

import com.thoughtworks.selenium.CommandProcessor;
import com.thoughtworks.selenium.DefaultSelenium;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.anadix.Anadix;
import org.anadix.Analyzer;
import org.anadix.Report;
import org.anadix.ReportFormatter;
import org.anadix.Source;
import org.anadix.exceptions.SourceException;
import org.anadix.factories.SourceFactory;
import org.anadix.utils.MultithreadedAnalyzer;
import org.anadix.utils.ResultException;

public class AnadixSelenium
extends DefaultSelenium {
    private final List<Source> sources = new ArrayList<Source>();
    private final List<Report> reports = new ArrayList<Report>();
    private final List<Throwable> exceptions = new ArrayList<Throwable>();
    private File sourcesDir = new File("sources");
    private File reportsDir = new File("reports");
    private MultithreadedAnalyzer analyzer;

    public AnadixSelenium(CommandProcessor processor) {
        super(processor);
    }

    public AnadixSelenium(String serverHost, int serverPort, String browserStartCommand, String browserURL) {
        super(serverHost, serverPort, browserStartCommand, browserURL);
    }

    public void click(String locator) {
        this.analyzeCurrentPage();
        super.click(locator);
    }

    public void clickAt(String locator, String coordString) {
        this.analyzeCurrentPage();
        super.clickAt(locator, coordString);
    }

    public void submit(String formLocator) {
        this.analyzeCurrentPage();
        super.submit(formLocator);
    }

    private void analyzeCurrentPage() {
        if (this.analyzer != null) {
            int id = this.analyzer.submittAnalysis(SourceFactory.newStringSource((String)this.getHtmlSource(), (String)this.getTitle()));
            try {
                this.reports.add(this.analyzer.getResult(id));
            }
            catch (ResultException ex) {
                throw new RuntimeException("Error durring analysis", ex);
            }
        }
        File f = AnadixSelenium.storeHtml(this.getSourcesDir(), this.getTitle(), this.getHtmlSource());
        try {
            this.sources.add(SourceFactory.newFileSource((File)f, (boolean)false));
        }
        catch (SourceException ex) {
            throw new RuntimeException("Error during source creation", ex);
        }
    }

    public void analyzeStoredPages() throws InstantiationException {
        this.analyzeStoredPages(Anadix.newAnalyzer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void analyzeStoredPages(Analyzer analyzer) {
        MultithreadedAnalyzer ma = new MultithreadedAnalyzer(analyzer);
        try {
            ArrayList<Integer> ids = new ArrayList<Integer>();
            for (Source s : this.getStoredSources()) {
                ids.add(ma.submittAnalysis(s));
            }
            while (ids.size() > 0) {
                Iterator it = ids.iterator();
                while (it.hasNext()) {
                    int id = (Integer)it.next();
                    try {
                        Report r = ma.getResult(id, false);
                        if (r == null) continue;
                        this.reports.add(r);
                        it.remove();
                    }
                    catch (ResultException ex) {
                        this.exceptions.add(ex);
                        it.remove();
                    }
                }
            }
        }
        finally {
            ma.dispose();
        }
    }

    public Collection<Source> getStoredSources() {
        return Collections.unmodifiableCollection(this.sources);
    }

    public Collection<Report> getStoredReports() {
        return Collections.unmodifiableCollection(this.reports);
    }

    public Collection<Throwable> getExceptions() {
        return Collections.unmodifiableCollection(this.exceptions);
    }

    public void dumpReports() {
        for (Report report : this.getStoredReports()) {
            File f = AnadixSelenium.storeHtml(this.getReportsDir(), report.getSource().getDescription(), "");
            try {
                Anadix.serializeReport((Report)report, (File)f);
            }
            catch (FileNotFoundException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public void dumpReports(ReportFormatter formatter) {
        for (Report report : this.getStoredReports()) {
            AnadixSelenium.storeHtml(this.getReportsDir(), report.getSource().getDescription(), formatter.format(report));
        }
    }

    public File getSourcesDir() {
        if (!this.sourcesDir.exists()) {
            this.sourcesDir.mkdir();
        }
        return this.sourcesDir;
    }

    public void setSourcesDir(File sourcesDir) {
        this.sourcesDir = sourcesDir;
    }

    public File getReportsDir() {
        if (!this.reportsDir.exists()) {
            this.reportsDir.mkdir();
        }
        return this.reportsDir;
    }

    public void setReportsDir(File reportsDir) {
        this.reportsDir = reportsDir;
    }

    public MultithreadedAnalyzer getAnalyzer() {
        return this.analyzer;
    }

    public void setAnalyzer(Analyzer analyzer) {
        if (this.analyzer != null) {
            this.analyzer.dispose();
        }
        this.analyzer = analyzer == null ? null : new MultithreadedAnalyzer(analyzer);
    }

    public void dispose() {
        this.analyzer.dispose();
    }

    private static File storeHtml(File directory, String name, String source) {
        return AnadixSelenium.storeHtml(directory, name, source, true);
    }

    private static File storeHtml(File directory, String name, String source, boolean retry) {
        File resultFile;
        int i = 0;
        name = name.replace("http://", "").replace("/", "_");
        while ((resultFile = new File(directory, String.format("%s_%s.html", name, i++))).exists()) {
        }
        try {
            resultFile.createNewFile();
        }
        catch (IOException e) {
            if (retry) {
                return AnadixSelenium.storeHtml(directory, name, source, false);
            }
            throw new RuntimeException("Unable to create file " + resultFile.getAbsolutePath(), e);
        }
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(resultFile);
            pw.println(source);
            pw.flush();
        }
        catch (FileNotFoundException ex) {
            throw new RuntimeException("This ought to not happen", ex);
        }
        finally {
            if (pw != null) {
                pw.close();
            }
        }
        return resultFile;
    }
}

