/*
 * Decompiled with CFR 0.152.
 */
package org.anasoid.jmc.core.application;

import com.thoughtworks.xstream.XStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.anasoid.jmc.core.application.InitInterceptor;
import org.anasoid.jmc.core.application.JMeterHome;
import org.anasoid.jmc.core.application.JmcXstream;
import org.anasoid.jmc.core.application.PrepareModuleControllerInterceptor;
import org.anasoid.jmc.core.application.ScriptWrapper;
import org.anasoid.jmc.core.application.interceptors.PrepareInterceptor;
import org.anasoid.jmc.core.application.validator.NodeValidatorManager;
import org.anasoid.jmc.core.wrapper.jmeter.testelement.TestElementWrapper;
import org.anasoid.jmc.core.wrapper.jmeter.testelement.TestPlanWrapper;
import org.anasoid.jmc.core.xstream.exceptions.ConversionException;
import org.anasoid.jmc.core.xstream.exceptions.ConversionExceptionHelper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.jmeter.engine.StandardJMeterEngine;
import org.apache.jmeter.save.SaveService;
import org.apache.jorphan.collections.HashTree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationTest {
    private static final Logger LOG = LoggerFactory.getLogger(ApplicationTest.class);
    private final TestPlanWrapper testPlanWrapper;
    private final TestElementWrapper<?> testElement;
    private final List<PrepareInterceptor> defaultPostInterceptors = new ArrayList<PrepareInterceptor>();
    private final List<PrepareInterceptor> defaultPreInterceptors = Arrays.asList(new InitInterceptor(), new PrepareModuleControllerInterceptor());
    private final List<PrepareInterceptor> prepareInterceptors;
    private boolean testMode;

    public ApplicationTest(TestPlanWrapper testPlanWrapper) {
        this(testPlanWrapper, (List<PrepareInterceptor>)new ArrayList<PrepareInterceptor>());
    }

    public ApplicationTest(TestPlanWrapper testPlanWrapper, List<PrepareInterceptor> prepareInterceptors) {
        this.testPlanWrapper = testPlanWrapper;
        this.testElement = null;
        ArrayList<PrepareInterceptor> interceptors = new ArrayList<PrepareInterceptor>(this.defaultPreInterceptors);
        if (prepareInterceptors != null) {
            interceptors.addAll(prepareInterceptors);
        }
        interceptors.addAll(this.defaultPostInterceptors);
        this.prepareInterceptors = interceptors;
    }

    protected ApplicationTest(TestElementWrapper<?> testElement, List<PrepareInterceptor> prepareInterceptors) {
        this.testElement = testElement;
        this.testPlanWrapper = null;
        ArrayList<PrepareInterceptor> interceptors = new ArrayList<PrepareInterceptor>(this.defaultPreInterceptors);
        if (prepareInterceptors != null) {
            interceptors.addAll(prepareInterceptors);
        }
        interceptors.addAll(this.defaultPostInterceptors);
        this.prepareInterceptors = interceptors;
        this.testMode = true;
    }

    protected ApplicationTest(TestElementWrapper<?> testElement) {
        this(testElement, new ArrayList<PrepareInterceptor>());
    }

    private static void init() {
        JMeterHome.getInstance().init();
    }

    private static void isInit() {
        if (!JMeterHome.getInstance().isInit()) {
            throw new IllegalStateException("Jmeter is not correctly initialized");
        }
    }

    public TestElementWrapper toJmx(Writer out) throws IOException {
        ScriptWrapper script = this.createScript();
        try (Writer writer = out;){
            out.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + System.lineSeparator());
            this.getXstream().toXML((Object)script, out);
        }
        if (this.testMode) {
            return this.testElement;
        }
        return script.getTestPlan();
    }

    public TestElementWrapper toJmx(File file) throws IOException {
        Path path = Paths.get(file.getPath(), new String[0]);
        path.toFile().getParentFile().mkdirs();
        return this.toJmx(Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]));
    }

    protected ScriptWrapper createScript() {
        ScriptWrapper script;
        if (this.testMode) {
            script = new ScriptWrapper().setTestPlan(this.testElement);
        } else {
            try {
                script = new ScriptWrapper().setTestPlan(this.clone(this.testPlanWrapper));
            }
            catch (IOException | ClassNotFoundException e) {
                throw new ConversionException(e);
            }
        }
        this.prepare(script);
        this.validate(script);
        return script;
    }

    protected void validate(ScriptWrapper script) {
        NodeValidatorManager.validate(script.getTestPlan());
    }

    private void prepare(TestElementWrapper<?> testPlan, TestElementWrapper<?> testElement, PrepareInterceptor interceptor, Set<TestElementWrapper<?>> history) {
        if (!history.contains(testElement)) {
            if (interceptor.support(testElement)) {
                try {
                    interceptor.prepare(testPlan, testElement);
                }
                catch (ConversionException e) {
                    ConversionExceptionHelper.setNode(e, testElement);
                    throw e;
                }
                catch (Exception e) {
                    throw new ConversionException(e, testElement);
                }
            }
            history.add(testElement);
            if (CollectionUtils.isNotEmpty(testElement.getChildren())) {
                for (TestElementWrapper<?> childElement : testElement.getChildren()) {
                    this.prepare(testPlan, childElement, interceptor, history);
                }
            }
        }
    }

    protected void prepare(ScriptWrapper script) {
        for (PrepareInterceptor interceptor : this.prepareInterceptors) {
            HashSet history = new HashSet();
            if (!CollectionUtils.isNotEmpty(this.prepareInterceptors)) continue;
            this.prepare(script.getTestPlan(), script.getTestPlan(), interceptor, history);
        }
    }

    private TestPlanWrapper clone(TestPlanWrapper in) throws IOException, ClassNotFoundException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(in);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        ObjectInputStream ois = new ObjectInputStream(bais);
        return (TestPlanWrapper)ois.readObject();
    }

    public void run() throws IOException {
        ApplicationTest.isInit();
        StandardJMeterEngine jmeter = new StandardJMeterEngine();
        File tmp = File.createTempFile("run_jmeter_", ".jmx");
        LOG.info("Run tmp file : {}", (Object)tmp);
        this.toJmx(Files.newBufferedWriter(Paths.get(tmp.getPath(), new String[0]), StandardCharsets.UTF_8, new OpenOption[0]));
        HashTree testPlanTree = SaveService.loadTree((File)tmp);
        jmeter.configure(testPlanTree);
        jmeter.run();
    }

    public void check() throws IOException {
        if (!this.testMode) {
            StandardJMeterEngine jmeter = new StandardJMeterEngine();
            File tmp = File.createTempFile("check_jmeter_", ".jmx");
            LOG.info("Check tmp file : {}", (Object)tmp);
            this.toJmx(Files.newBufferedWriter(Paths.get(tmp.getPath(), new String[0]), StandardCharsets.UTF_8, new OpenOption[0]));
            HashTree testPlanTree = SaveService.loadTree((File)tmp);
            jmeter.configure(testPlanTree);
        }
    }

    private XStream getXstream() {
        return new JmcXstream();
    }

    static {
        LOG.info("ApplicationTest Initialization");
        ApplicationTest.init();
    }
}

