/*
 * Decompiled with CFR 0.152.
 */
package org.anasoid.jmc.core.wrapper.jmc;

import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.NonNull;

public class Variable
implements Serializable {
    @XStreamOmitField
    private static final long serialVersionUID = -2353696454050745099L;
    private final String name;

    public Variable(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.name = name;
    }

    public static List<Variable> asVariables(@NonNull List<String> variables) {
        if (variables == null) {
            throw new NullPointerException("variables is marked non-null but is null");
        }
        return variables.stream().map(Variable::new).collect(Collectors.toList());
    }

    public static List<Variable> asVariables(String ... variables) {
        if (variables == null) {
            throw new NullPointerException("variables is marked non-null but is null");
        }
        return Variable.asVariables(Arrays.asList(variables));
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return "${" + this.name + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Variable variable = (Variable)o;
        return this.name.equals(variable.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public String toString() {
        return "Variable{name='" + this.name + "'}";
    }
}

