/*
 * Decompiled with CFR 0.152.
 */
package org.anasoid.jmc.core.wrapper.jmeter.assertions;

import com.thoughtworks.xstream.annotations.XStreamOmitField;
import org.anasoid.jmc.core.config.JmcConfig;
import org.anasoid.jmc.core.wrapper.jmc.validator.Validator;
import org.anasoid.jmc.core.wrapper.jmeter.gui.JMeterGUIWrapper;
import org.anasoid.jmc.core.wrapper.jmeter.testelement.AssertionWrapper;
import org.anasoid.jmc.core.wrapper.jmeter.testelement.basic.AbstractBasicChildTestElementWrapper;
import org.anasoid.jmc.core.xstream.annotations.JmcDefaultName;
import org.anasoid.jmc.core.xstream.annotations.JmcProperty;
import org.anasoid.jmc.core.xstream.exceptions.ConversionIllegalStateException;
import org.apache.jmeter.assertions.HTMLAssertion;
import org.apache.jmeter.assertions.gui.HTMLAssertionGui;

@JmcDefaultName(value="HTML Assertion")
public class HTMLAssertionWrapper
extends AbstractBasicChildTestElementWrapper<HTMLAssertion>
implements JMeterGUIWrapper<HTMLAssertionGui>,
AssertionWrapper<HTMLAssertion>,
Validator {
    @JmcProperty(value="html_assertion_error_threshold", type=Long.class)
    private Integer errorThreshold;
    @JmcProperty(value="html_assertion_warning_threshold", type=Long.class)
    private Integer warningThreshold;
    @JmcProperty(value="html_assertion_format")
    private Format format;
    @JmcProperty(value="html_assertion_errorsonly")
    private boolean errorOnly;
    @JmcProperty(value="html_assertion_doctype")
    private Doctype doctype;
    @XStreamOmitField
    private String filename;

    @JmcProperty(value="html_assertion_filename")
    protected String getFilePath() {
        if (this.filename == null) {
            return "";
        }
        return JmcConfig.getResultRootFolder() + this.filename;
    }

    @Override
    public Class<?> getGuiClass() {
        return HTMLAssertionGui.class;
    }

    @Override
    public Class<?> getTestClass() {
        return HTMLAssertion.class;
    }

    @Override
    public void validate() throws ConversionIllegalStateException {
        if (this.errorOnly && this.warningThreshold != 0) {
            throw new ConversionIllegalStateException("warningThreshold can't be used with errorOnly");
        }
    }

    private static Integer $default$errorThreshold() {
        return 0;
    }

    private static Integer $default$warningThreshold() {
        return 0;
    }

    private static Format $default$format() {
        return Format.HTML;
    }

    private static boolean $default$errorOnly() {
        return false;
    }

    private static Doctype $default$doctype() {
        return Doctype.OMIT;
    }

    protected HTMLAssertionWrapper(HTMLAssertionWrapperBuilder<?, ?> b) {
        super(b);
        this.errorThreshold = b.errorThreshold$set ? b.errorThreshold$value : HTMLAssertionWrapper.$default$errorThreshold();
        this.warningThreshold = b.warningThreshold$set ? b.warningThreshold$value : HTMLAssertionWrapper.$default$warningThreshold();
        this.format = b.format$set ? b.format$value : HTMLAssertionWrapper.$default$format();
        this.errorOnly = b.errorOnly$set ? b.errorOnly$value : HTMLAssertionWrapper.$default$errorOnly();
        this.doctype = b.doctype$set ? b.doctype$value : HTMLAssertionWrapper.$default$doctype();
        this.filename = b.filename;
    }

    public static HTMLAssertionWrapperBuilder<?, ?> builder() {
        return new HTMLAssertionWrapperBuilderImpl();
    }

    public HTMLAssertionWrapperBuilder<?, ?> toBuilder() {
        return new HTMLAssertionWrapperBuilderImpl().$fillValuesFrom(this);
    }

    public Integer getErrorThreshold() {
        return this.errorThreshold;
    }

    public void setErrorThreshold(Integer errorThreshold) {
        this.errorThreshold = errorThreshold;
    }

    public Integer getWarningThreshold() {
        return this.warningThreshold;
    }

    public void setWarningThreshold(Integer warningThreshold) {
        this.warningThreshold = warningThreshold;
    }

    public Format getFormat() {
        return this.format;
    }

    public void setFormat(Format format) {
        this.format = format;
    }

    public boolean isErrorOnly() {
        return this.errorOnly;
    }

    public void setErrorOnly(boolean errorOnly) {
        this.errorOnly = errorOnly;
    }

    public Doctype getDoctype() {
        return this.doctype;
    }

    public void setDoctype(Doctype doctype) {
        this.doctype = doctype;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    private static final class HTMLAssertionWrapperBuilderImpl
    extends HTMLAssertionWrapperBuilder<HTMLAssertionWrapper, HTMLAssertionWrapperBuilderImpl> {
        private HTMLAssertionWrapperBuilderImpl() {
        }

        @Override
        protected HTMLAssertionWrapperBuilderImpl self() {
            return this;
        }

        @Override
        public HTMLAssertionWrapper build() {
            return new HTMLAssertionWrapper(this);
        }
    }

    public static abstract class HTMLAssertionWrapperBuilder<C extends HTMLAssertionWrapper, B extends HTMLAssertionWrapperBuilder<C, B>>
    extends AbstractBasicChildTestElementWrapper.AbstractBasicChildTestElementWrapperBuilder<HTMLAssertion, C, B> {
        private boolean errorThreshold$set;
        private Integer errorThreshold$value;
        private boolean warningThreshold$set;
        private Integer warningThreshold$value;
        private boolean format$set;
        private Format format$value;
        private boolean errorOnly$set;
        private boolean errorOnly$value;
        private boolean doctype$set;
        private Doctype doctype$value;
        private String filename;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            HTMLAssertionWrapperBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(HTMLAssertionWrapper instance, HTMLAssertionWrapperBuilder<?, ?> b) {
            b.withErrorThreshold(instance.errorThreshold);
            b.withWarningThreshold(instance.warningThreshold);
            b.withFormat(instance.format);
            b.withErrorOnly(instance.errorOnly);
            b.withDoctype(instance.doctype);
            b.withFilename(instance.filename);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B withErrorThreshold(Integer errorThreshold) {
            this.errorThreshold$value = errorThreshold;
            this.errorThreshold$set = true;
            return (B)this.self();
        }

        public B withWarningThreshold(Integer warningThreshold) {
            this.warningThreshold$value = warningThreshold;
            this.warningThreshold$set = true;
            return (B)this.self();
        }

        public B withFormat(Format format) {
            this.format$value = format;
            this.format$set = true;
            return (B)this.self();
        }

        public B withErrorOnly(boolean errorOnly) {
            this.errorOnly$value = errorOnly;
            this.errorOnly$set = true;
            return (B)this.self();
        }

        public B withDoctype(Doctype doctype) {
            this.doctype$value = doctype;
            this.doctype$set = true;
            return (B)this.self();
        }

        public B withFilename(String filename) {
            this.filename = filename;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "HTMLAssertionWrapper.HTMLAssertionWrapperBuilder(super=" + super.toString() + ", errorThreshold$value=" + this.errorThreshold$value + ", warningThreshold$value=" + this.warningThreshold$value + ", format$value=" + this.format$value + ", errorOnly$value=" + this.errorOnly$value + ", doctype$value=" + this.doctype$value + ", filename=" + this.filename + ")";
        }
    }

    public static enum Doctype {
        OMIT("omit"),
        AUTO("auto"),
        STRICT("strict"),
        LOOSE("loose");

        private final String value;

        private Doctype(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum Format {
        HTML(0L),
        XHTML(1L),
        XML(2L);

        private final Long value;

        private Format(Long value) {
            this.value = value;
        }

        public Long getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

