/*
 * Decompiled with CFR 0.152.
 */
package org.anasoid.jmc.core.wrapper.jmeter.assertions;

import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.anasoid.jmc.core.wrapper.jmeter.testelement.AbstractScopedTestElementWrapper;
import org.anasoid.jmc.core.wrapper.jmeter.testelement.AssertionWrapper;
import org.anasoid.jmc.core.xstream.annotations.JmcDefaultName;
import org.anasoid.jmc.core.xstream.annotations.JmcMandatory;
import org.anasoid.jmc.core.xstream.annotations.JmcProperty;
import org.apache.commons.collections.CollectionUtils;
import org.apache.jmeter.assertions.XPath2Assertion;
import org.apache.jmeter.assertions.gui.XPath2AssertionGui;

@JmcDefaultName(value="XPath2 Assertion")
public class XPath2AssertionWrapper
extends AbstractScopedTestElementWrapper<XPath2Assertion, XPath2AssertionGui>
implements AssertionWrapper<XPath2Assertion> {
    @JmcProperty(value="XPath.xpath")
    @JmcMandatory
    private String xpath;
    @JmcProperty(value="XPath.negate")
    private boolean negate;
    @JmcProperty(value="XPath.namespaces")
    @XStreamOmitField
    private List<String> namespaces;

    @JmcProperty(value="XPath.namespaces")
    protected String namespacesProp() {
        if (CollectionUtils.isEmpty(this.namespaces)) {
            return "";
        }
        return String.join((CharSequence)"\n", this.namespaces);
    }

    @Override
    public Class<?> getGuiClass() {
        return XPath2AssertionGui.class;
    }

    @Override
    public Class<?> getTestClass() {
        return XPath2Assertion.class;
    }

    private static boolean $default$negate() {
        return false;
    }

    protected XPath2AssertionWrapper(XPath2AssertionWrapperBuilder<?, ?> b) {
        super(b);
        this.xpath = b.xpath;
        this.negate = b.negate$set ? b.negate$value : XPath2AssertionWrapper.$default$negate();
        this.namespaces = b.namespaces;
    }

    public static XPath2AssertionWrapperBuilder<?, ?> builder() {
        return new XPath2AssertionWrapperBuilderImpl();
    }

    public XPath2AssertionWrapperBuilder<?, ?> toBuilder() {
        return new XPath2AssertionWrapperBuilderImpl().$fillValuesFrom(this);
    }

    public String getXpath() {
        return this.xpath;
    }

    public void setXpath(String xpath) {
        this.xpath = xpath;
    }

    public boolean isNegate() {
        return this.negate;
    }

    public void setNegate(boolean negate) {
        this.negate = negate;
    }

    public List<String> getNamespaces() {
        return this.namespaces;
    }

    public void setNamespaces(List<String> namespaces) {
        this.namespaces = namespaces;
    }

    private static final class XPath2AssertionWrapperBuilderImpl
    extends XPath2AssertionWrapperBuilder<XPath2AssertionWrapper, XPath2AssertionWrapperBuilderImpl> {
        private XPath2AssertionWrapperBuilderImpl() {
        }

        @Override
        protected XPath2AssertionWrapperBuilderImpl self() {
            return this;
        }

        @Override
        public XPath2AssertionWrapper build() {
            return new XPath2AssertionWrapper(this);
        }
    }

    public static abstract class XPath2AssertionWrapperBuilder<C extends XPath2AssertionWrapper, B extends XPath2AssertionWrapperBuilder<C, B>>
    extends AbstractScopedTestElementWrapper.AbstractScopedTestElementWrapperBuilder<XPath2Assertion, XPath2AssertionGui, C, B> {
        private String xpath;
        private boolean negate$set;
        private boolean negate$value;
        private List<String> namespaces;

        protected B withNamespaces(List<String> namespaces) {
            this.namespaces = namespaces;
            return (B)this.self();
        }

        public B addNamespaces(List<String> namespaces) {
            if (this.namespaces == null) {
                this.withNamespaces(new ArrayList<String>());
            }
            this.namespaces.addAll(namespaces);
            return (B)this.self();
        }

        public B addNamespace(String value) {
            return this.addNamespaces(Arrays.asList(value));
        }

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            XPath2AssertionWrapperBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(XPath2AssertionWrapper instance, XPath2AssertionWrapperBuilder<?, ?> b) {
            b.withXpath(instance.xpath);
            b.withNegate(instance.negate);
            b.withNamespaces(instance.namespaces);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B withXpath(String xpath) {
            this.xpath = xpath;
            return (B)this.self();
        }

        public B withNegate(boolean negate) {
            this.negate$value = negate;
            this.negate$set = true;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "XPath2AssertionWrapper.XPath2AssertionWrapperBuilder(super=" + super.toString() + ", xpath=" + this.xpath + ", negate$value=" + this.negate$value + ", namespaces=" + this.namespaces + ")";
        }
    }
}

