/*
 * Decompiled with CFR 0.152.
 */
package org.anasoid.jmc.core.wrapper.jmeter.config;

import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.anasoid.jmc.core.config.JmcConfig;
import org.anasoid.jmc.core.wrapper.jmc.Variable;
import org.anasoid.jmc.core.wrapper.jmc.config.ShareMode;
import org.anasoid.jmc.core.wrapper.jmc.validator.Validator;
import org.anasoid.jmc.core.wrapper.jmeter.config.ConfigTestElementWrapper;
import org.anasoid.jmc.core.xstream.annotations.JmcDefaultName;
import org.anasoid.jmc.core.xstream.annotations.JmcNullAllowed;
import org.anasoid.jmc.core.xstream.annotations.JmcProperty;
import org.anasoid.jmc.core.xstream.exceptions.ConversionException;
import org.anasoid.jmc.core.xstream.exceptions.ConversionIllegalStateException;
import org.anasoid.jmc.core.xstream.types.BooleanManager;
import org.apache.jmeter.config.CSVDataSet;
import org.apache.jmeter.testbeans.gui.TestBeanGUI;

@JmcDefaultName(value="CSV Data Set Config")
public class CSVDataSetWrapper
extends ConfigTestElementWrapper<CSVDataSet, TestBeanGUI>
implements Validator {
    @XStreamOmitField
    private static final long serialVersionUID = -1283066246657871689L;
    @XStreamOmitField
    private final List<Variable> variables;
    @XStreamOmitField
    private String filename;
    @XStreamOmitField
    boolean asResourceFile;
    @JmcProperty(value="fileEncoding")
    @JmcNullAllowed
    private String fileEncoding;
    @JmcProperty(value="ignoreFirstLine", type=BooleanManager.class)
    private String ignoreFirstLine;
    @JmcProperty(value="delimiter")
    @NonNull
    private String delimiter;
    @JmcProperty(value="recycle", type=BooleanManager.class)
    private String recycle;
    @JmcProperty(value="stopThread", type=BooleanManager.class)
    private String stopThread;
    @JmcProperty(value="quotedData", type=BooleanManager.class)
    private String quotedData;
    @JmcProperty(value="shareMode")
    private String shareMode;

    @JmcProperty(value="filename")
    protected String getFilePath() {
        if (this.filename == null) {
            return null;
        }
        if (this.asResourceFile) {
            URL url = Thread.currentThread().getContextClassLoader().getResource(this.filename);
            if (url == null) {
                throw new ConversionException("ResourceFile not found : " + this.filename);
            }
            return url.getFile();
        }
        return JmcConfig.getDataRootFolder() + this.filename;
    }

    @JmcProperty(value="variableNames")
    protected String getVariableNames() {
        if (this.variables.isEmpty()) {
            return "";
        }
        return String.join((CharSequence)",", this.variables.stream().map(Variable::getName).collect(Collectors.toList()));
    }

    @Override
    public Class<?> getGuiClass() {
        return TestBeanGUI.class;
    }

    @Override
    public Class<?> getTestClass() {
        return CSVDataSet.class;
    }

    @Override
    public void validate() throws ConversionIllegalStateException {
        if (this.getFilePath() == null) {
            throw new ConversionIllegalStateException("Filename not provided");
        }
        if (this.getVariables().isEmpty()) {
            throw new ConversionIllegalStateException("Variables is mandatory");
        }
    }

    private static List<Variable> $default$variables() {
        return new ArrayList<Variable>();
    }

    private static boolean $default$asResourceFile() {
        return JmcConfig.isDataResource();
    }

    private static String $default$ignoreFirstLine() {
        return "false";
    }

    private static String $default$delimiter() {
        return ",";
    }

    private static String $default$recycle() {
        return "true";
    }

    private static String $default$stopThread() {
        return "false";
    }

    private static String $default$quotedData() {
        return "false";
    }

    private static String $default$shareMode() {
        return ShareMode.SHARE_ALL.getValue();
    }

    protected CSVDataSetWrapper(CSVDataSetWrapperBuilder<?, ?> b) {
        super(b);
        this.variables = b.variables$set ? b.variables$value : CSVDataSetWrapper.$default$variables();
        this.filename = b.filename;
        this.asResourceFile = b.asResourceFile$set ? b.asResourceFile$value : CSVDataSetWrapper.$default$asResourceFile();
        this.fileEncoding = b.fileEncoding;
        this.ignoreFirstLine = b.ignoreFirstLine$set ? b.ignoreFirstLine$value : CSVDataSetWrapper.$default$ignoreFirstLine();
        this.delimiter = b.delimiter$set ? b.delimiter$value : CSVDataSetWrapper.$default$delimiter();
        if (this.delimiter == null) {
            throw new NullPointerException("delimiter is marked non-null but is null");
        }
        this.recycle = b.recycle$set ? b.recycle$value : CSVDataSetWrapper.$default$recycle();
        this.stopThread = b.stopThread$set ? b.stopThread$value : CSVDataSetWrapper.$default$stopThread();
        this.quotedData = b.quotedData$set ? b.quotedData$value : CSVDataSetWrapper.$default$quotedData();
        this.shareMode = b.shareMode$set ? b.shareMode$value : CSVDataSetWrapper.$default$shareMode();
    }

    public static CSVDataSetWrapperBuilder<?, ?> builder() {
        return new CSVDataSetWrapperBuilderImpl();
    }

    public CSVDataSetWrapperBuilder<?, ?> toBuilder() {
        return new CSVDataSetWrapperBuilderImpl().$fillValuesFrom(this);
    }

    public List<Variable> getVariables() {
        return this.variables;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public boolean isAsResourceFile() {
        return this.asResourceFile;
    }

    public void setAsResourceFile(boolean asResourceFile) {
        this.asResourceFile = asResourceFile;
    }

    public String getFileEncoding() {
        return this.fileEncoding;
    }

    public void setFileEncoding(String fileEncoding) {
        this.fileEncoding = fileEncoding;
    }

    public String getIgnoreFirstLine() {
        return this.ignoreFirstLine;
    }

    public void setIgnoreFirstLine(String ignoreFirstLine) {
        this.ignoreFirstLine = ignoreFirstLine;
    }

    @NonNull
    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(@NonNull String delimiter) {
        if (delimiter == null) {
            throw new NullPointerException("delimiter is marked non-null but is null");
        }
        this.delimiter = delimiter;
    }

    public String getRecycle() {
        return this.recycle;
    }

    public void setRecycle(String recycle) {
        this.recycle = recycle;
    }

    public String getStopThread() {
        return this.stopThread;
    }

    public void setStopThread(String stopThread) {
        this.stopThread = stopThread;
    }

    public String getQuotedData() {
        return this.quotedData;
    }

    public void setQuotedData(String quotedData) {
        this.quotedData = quotedData;
    }

    public String getShareMode() {
        return this.shareMode;
    }

    public void setShareMode(String shareMode) {
        this.shareMode = shareMode;
    }

    private static final class CSVDataSetWrapperBuilderImpl
    extends CSVDataSetWrapperBuilder<CSVDataSetWrapper, CSVDataSetWrapperBuilderImpl> {
        private CSVDataSetWrapperBuilderImpl() {
        }

        @Override
        protected CSVDataSetWrapperBuilderImpl self() {
            return this;
        }

        @Override
        public CSVDataSetWrapper build() {
            return new CSVDataSetWrapper(this);
        }
    }

    public static abstract class CSVDataSetWrapperBuilder<C extends CSVDataSetWrapper, B extends CSVDataSetWrapperBuilder<C, B>>
    extends ConfigTestElementWrapper.ConfigTestElementWrapperBuilder<CSVDataSet, TestBeanGUI, C, B> {
        private boolean variables$set;
        private List<Variable> variables$value;
        private String filename;
        private boolean asResourceFile$set;
        private boolean asResourceFile$value;
        private String fileEncoding;
        private boolean ignoreFirstLine$set;
        private String ignoreFirstLine$value;
        private boolean delimiter$set;
        private String delimiter$value;
        private boolean recycle$set;
        private String recycle$value;
        private boolean stopThread$set;
        private String stopThread$value;
        private boolean quotedData$set;
        private String quotedData$value;
        private boolean shareMode$set;
        private String shareMode$value;

        public B withIgnoreFirstLine(Boolean ignoreFirstLine) {
            return this.withIgnoreFirstLine(String.valueOf(ignoreFirstLine));
        }

        public B withIgnoreFirstLine(Variable ignoreFirstLine) {
            return this.withIgnoreFirstLine(ignoreFirstLine.getValue());
        }

        public B withIgnoreFirstLine(String ignoreFirstLine) {
            this.ignoreFirstLine$value = ignoreFirstLine;
            this.ignoreFirstLine$set = true;
            return (B)this.self();
        }

        public B withRecycle(Boolean recycle) {
            return this.withRecycle(String.valueOf(recycle));
        }

        public B withRecycle(Variable recycle) {
            return this.withRecycle(recycle.getValue());
        }

        public B withRecycle(String recycle) {
            this.recycle$value = recycle;
            this.recycle$set = true;
            return (B)this.self();
        }

        public B withStopThread(Boolean stopThread) {
            return this.withStopThread(String.valueOf(stopThread));
        }

        public B withStopThread(Variable stopThread) {
            return this.withStopThread(stopThread.getValue());
        }

        public B withStopThread(String stopThread) {
            this.stopThread$value = stopThread;
            this.stopThread$set = true;
            return (B)this.self();
        }

        public B withQuotedData(Boolean quotedData) {
            return this.withQuotedData(String.valueOf(quotedData));
        }

        public B withQuotedData(Variable quotedData) {
            return this.withQuotedData(quotedData.getValue());
        }

        public B withQuotedData(String quotedData) {
            this.quotedData$value = quotedData;
            this.quotedData$set = true;
            return (B)this.self();
        }

        public B withShareMode(ShareMode shareMode) {
            return this.withShareMode(shareMode.toString());
        }

        public B withShareMode(Variable shareMode) {
            return this.withShareMode(shareMode.getValue());
        }

        public B withShareMode(String shareMode) {
            this.shareMode$value = shareMode;
            this.shareMode$set = true;
            return (B)this.self();
        }

        protected B withVariables(List<Variable> variables) {
            this.variables$value = variables;
            this.variables$set = true;
            return (B)this.self();
        }

        public B addvariables(List<Variable> variables) {
            if (!this.variables$set) {
                this.withVariables(new ArrayList<Variable>());
            }
            this.variables$value.addAll(variables);
            return (B)this.self();
        }

        public B addvariable(Variable variable) {
            return this.addvariables(Arrays.asList(variable));
        }

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            CSVDataSetWrapperBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(CSVDataSetWrapper instance, CSVDataSetWrapperBuilder<?, ?> b) {
            b.withVariables(instance.variables);
            b.withFilename(instance.filename);
            b.withAsResourceFile(instance.asResourceFile);
            b.withFileEncoding(instance.fileEncoding);
            b.withIgnoreFirstLine(instance.ignoreFirstLine);
            b.withDelimiter(instance.delimiter);
            b.withRecycle(instance.recycle);
            b.withStopThread(instance.stopThread);
            b.withQuotedData(instance.quotedData);
            b.withShareMode(instance.shareMode);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B withFilename(String filename) {
            this.filename = filename;
            return (B)this.self();
        }

        public B withAsResourceFile(boolean asResourceFile) {
            this.asResourceFile$value = asResourceFile;
            this.asResourceFile$set = true;
            return (B)this.self();
        }

        public B withFileEncoding(String fileEncoding) {
            this.fileEncoding = fileEncoding;
            return (B)this.self();
        }

        public B withDelimiter(@NonNull String delimiter) {
            if (delimiter == null) {
                throw new NullPointerException("delimiter is marked non-null but is null");
            }
            this.delimiter$value = delimiter;
            this.delimiter$set = true;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "CSVDataSetWrapper.CSVDataSetWrapperBuilder(super=" + super.toString() + ", variables$value=" + this.variables$value + ", filename=" + this.filename + ", asResourceFile$value=" + this.asResourceFile$value + ", fileEncoding=" + this.fileEncoding + ", ignoreFirstLine$value=" + this.ignoreFirstLine$value + ", delimiter$value=" + this.delimiter$value + ", recycle$value=" + this.recycle$value + ", stopThread$value=" + this.stopThread$value + ", quotedData$value=" + this.quotedData$value + ", shareMode$value=" + this.shareMode$value + ")";
        }
    }
}

