/*
 * Decompiled with CFR 0.152.
 */
package org.anasoid.jmc.core.wrapper.jmeter.sampler;

import org.anasoid.jmc.core.wrapper.jmc.Variable;
import org.anasoid.jmc.core.wrapper.jmc.validator.Validator;
import org.anasoid.jmc.core.wrapper.jmeter.samplers.AbstractSamplerWrapper;
import org.anasoid.jmc.core.xstream.annotations.JmcDefaultName;
import org.anasoid.jmc.core.xstream.annotations.JmcProperty;
import org.anasoid.jmc.core.xstream.exceptions.ConversionIllegalStateException;
import org.apache.jmeter.sampler.TestAction;
import org.apache.jmeter.sampler.gui.TestActionGui;

@JmcDefaultName(value="Flow Control Action")
public class TestActionWrapper
extends AbstractSamplerWrapper<TestAction, TestActionGui>
implements Validator {
    @JmcProperty(value="ActionProcessor.action")
    private Action action;
    @JmcProperty(value="ActionProcessor.target")
    private Target target;
    @JmcProperty(value="ActionProcessor.duration")
    private String duration;

    @Override
    public Class<?> getGuiClass() {
        return TestActionGui.class;
    }

    @Override
    public Class<?> getTestClass() {
        return TestAction.class;
    }

    @Override
    public void validate() throws ConversionIllegalStateException {
        if (!Action.PAUSE.equals((Object)this.action) && !"0".equals(this.duration)) {
            throw new ConversionIllegalStateException("Duration is valid only for Pause action");
        }
        if (!(Action.STOP.equals((Object)this.action) || Action.STOP_NOW.equals((Object)this.action) || Target.CURRENT_THREAD.equals((Object)this.target))) {
            throw new ConversionIllegalStateException("Targte Thread is valid only for stop action");
        }
    }

    private static Action $default$action() {
        return Action.PAUSE;
    }

    private static Target $default$target() {
        return Target.CURRENT_THREAD;
    }

    private static String $default$duration() {
        return "0";
    }

    protected TestActionWrapper(TestActionWrapperBuilder<?, ?> b) {
        super(b);
        this.action = b.action$set ? b.action$value : TestActionWrapper.$default$action();
        this.target = b.target$set ? b.target$value : TestActionWrapper.$default$target();
        this.duration = b.duration$set ? b.duration$value : TestActionWrapper.$default$duration();
    }

    public static TestActionWrapperBuilder<?, ?> builder() {
        return new TestActionWrapperBuilderImpl();
    }

    public TestActionWrapperBuilder<?, ?> toBuilder() {
        return new TestActionWrapperBuilderImpl().$fillValuesFrom(this);
    }

    public Action getAction() {
        return this.action;
    }

    public void setAction(Action action) {
        this.action = action;
    }

    public Target getTarget() {
        return this.target;
    }

    public void setTarget(Target target) {
        this.target = target;
    }

    public String getDuration() {
        return this.duration;
    }

    public void setDuration(String duration) {
        this.duration = duration;
    }

    private static final class TestActionWrapperBuilderImpl
    extends TestActionWrapperBuilder<TestActionWrapper, TestActionWrapperBuilderImpl> {
        private TestActionWrapperBuilderImpl() {
        }

        @Override
        protected TestActionWrapperBuilderImpl self() {
            return this;
        }

        @Override
        public TestActionWrapper build() {
            return new TestActionWrapper(this);
        }
    }

    public static abstract class TestActionWrapperBuilder<C extends TestActionWrapper, B extends TestActionWrapperBuilder<C, B>>
    extends AbstractSamplerWrapper.AbstractSamplerWrapperBuilder<TestAction, TestActionGui, C, B> {
        private boolean action$set;
        private Action action$value;
        private boolean target$set;
        private Target target$value;
        private boolean duration$set;
        private String duration$value;

        public B withDuration(String duration) {
            this.duration$value = duration;
            this.duration$set = true;
            return (B)this.self();
        }

        public B withDuration(Integer duration) {
            return this.withDuration(String.valueOf(duration));
        }

        public B withDuration(Variable duration) {
            return this.withDuration(String.valueOf(duration.getValue()));
        }

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            TestActionWrapperBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(TestActionWrapper instance, TestActionWrapperBuilder<?, ?> b) {
            b.withAction(instance.action);
            b.withTarget(instance.target);
            b.withDuration(instance.duration);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B withAction(Action action) {
            this.action$value = action;
            this.action$set = true;
            return (B)this.self();
        }

        public B withTarget(Target target) {
            this.target$value = target;
            this.target$set = true;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "TestActionWrapper.TestActionWrapperBuilder(super=" + super.toString() + ", action$value=" + this.action$value + ", target$value=" + this.target$value + ", duration$value=" + this.duration$value + ")";
        }
    }

    public static enum Action {
        STOP(0),
        PAUSE(1),
        STOP_NOW(2),
        RESTART_NEXT_LOOP(3),
        START_NEXT_ITERATION_CURRENT_LOOP(4),
        BREAK_CURRENT_LOOP(5);

        private final Integer value;

        private Action(Integer value) {
            this.value = value;
        }

        public Integer getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum Target {
        CURRENT_THREAD(0),
        ALL_THREAD(2);

        private final Integer value;

        private Target(Integer value) {
            this.value = value;
        }

        public Integer getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

