/*
 * Decompiled with CFR 0.152.
 */
package org.anasoid.jmc.core.xstream.converters;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.anasoid.jmc.core.application.InitHelper;
import org.anasoid.jmc.core.wrapper.jmc.Variable;
import org.anasoid.jmc.core.wrapper.jmc.generic.AbstractJmxIncludeWrapper;
import org.anasoid.jmc.core.wrapper.jmc.validator.Validator;
import org.anasoid.jmc.core.wrapper.jmeter.testelement.TestElementWrapper;
import org.anasoid.jmc.core.wrapper.jmeter.testelement.property.JMeterProperty;
import org.anasoid.jmc.core.xstream.ConverterBeanUtils;
import org.anasoid.jmc.core.xstream.annotations.JmcCollection;
import org.anasoid.jmc.core.xstream.annotations.JmcProperty;
import org.anasoid.jmc.core.xstream.exceptions.ConversionException;
import org.anasoid.jmc.core.xstream.exceptions.ConversionExceptionHelper;
import org.anasoid.jmc.core.xstream.io.xml.JmcXstreamWriter;
import org.apache.commons.collections.CollectionUtils;

public class TestElementConverter
implements Converter {
    private boolean inElementConversion;

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        AccessibleObject currentField = null;
        try {
            AccessibleObject accessibleObject;
            InitHelper.init(source);
            this.validate(source);
            ArrayList<AccessibleObject> allFieldsMethods = new ArrayList<AccessibleObject>();
            allFieldsMethods.addAll(ConverterBeanUtils.getFields(source));
            allFieldsMethods.addAll(ConverterBeanUtils.getMethods(source));
            List<AccessibleObject> attributes = ConverterBeanUtils.getAttributeOnly(allFieldsMethods);
            ArrayList<AccessibleObject> nonAttributes = new ArrayList<AccessibleObject>(allFieldsMethods);
            nonAttributes.removeAll(attributes);
            Iterator<AccessibleObject> iterator = attributes.iterator();
            while (iterator.hasNext()) {
                currentField = accessibleObject = iterator.next();
                this.convertField(source, accessibleObject, writer, context);
            }
            iterator = nonAttributes.iterator();
            while (iterator.hasNext()) {
                currentField = accessibleObject = iterator.next();
                this.convertField(source, accessibleObject, writer, context);
            }
            currentField = null;
            this.appendChild(source, writer, context, true);
        }
        catch (ConversionException e) {
            ConversionExceptionHelper.setNode(e, source);
            ConversionExceptionHelper.setField(e, currentField);
            throw e;
        }
        catch (Exception e) {
            ConversionException ce = new ConversionException(e, source);
            ConversionExceptionHelper.setField(ce, currentField);
            throw ce;
        }
    }

    protected void convertField(Object source, AccessibleObject accessibleObject, HierarchicalStreamWriter writer, MarshallingContext context) {
        if (!ConverterBeanUtils.shouldSkip(source, accessibleObject)) {
            Object value = ConverterBeanUtils.getValue(accessibleObject, source);
            if (ConverterBeanUtils.isAttribute(accessibleObject)) {
                this.convertAttributeField(value, accessibleObject, writer, context);
            } else if (ConverterBeanUtils.isProperty(accessibleObject)) {
                this.convertProperty(value, accessibleObject, writer, context);
            } else if (ConverterBeanUtils.isCollection(accessibleObject)) {
                this.convertCollection(value, accessibleObject, writer, context);
            } else {
                this.convertChildField(value, accessibleObject, writer, context);
            }
        }
    }

    protected void appendChild(Object source, HierarchicalStreamWriter writer, MarshallingContext context, boolean closeFirst) {
        if (this.inElementConversion) {
            return;
        }
        if (source instanceof TestElementWrapper) {
            List<TestElementWrapper<?>> children = ((TestElementWrapper)source).getChildren();
            if (closeFirst) {
                writer.endNode();
            }
            writer.startNode("hashTree");
            if (children != null) {
                int i = 0;
                for (TestElementWrapper<?> child : children) {
                    if (child instanceof AbstractJmxIncludeWrapper) {
                        this.include((AbstractJmxIncludeWrapper)child, writer, context, i);
                    } else {
                        writer.startNode(child.getTestClassAsString());
                        context.convertAnother(child);
                        writer.endNode();
                    }
                    ++i;
                }
            }
            if (!closeFirst) {
                writer.endNode();
            }
        }
    }

    private void include(AbstractJmxIncludeWrapper<?> includeWrapper, HierarchicalStreamWriter writer, MarshallingContext context, int count) {
        try {
            includeWrapper.init();
            Method method = includeWrapper.getClass().getMethod("toXml", new Class[0]);
            String result = (String)method.invoke(includeWrapper, new Object[0]);
            if (writer instanceof JmcXstreamWriter) {
                JmcXstreamWriter jmcXstreamWriter = (JmcXstreamWriter)writer;
                if (count == 0) {
                    jmcXstreamWriter.setValue("");
                }
                jmcXstreamWriter.writeRaw("\n");
                jmcXstreamWriter.writeRaw(result);
                if (CollectionUtils.isNotEmpty(includeWrapper.getChildren())) {
                    this.appendChild(includeWrapper, writer, context, false);
                }
            }
        }
        catch (IOException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new ConversionException(e);
        }
    }

    protected void validate(Object source) {
        if (source instanceof Validator) {
            ((Validator)source).validate();
        }
    }

    protected void convertAttributeField(Object value, AccessibleObject accessibleObject, HierarchicalStreamWriter writer, MarshallingContext context) {
        String alias = ConverterBeanUtils.getAlias(accessibleObject);
        writer.addAttribute(alias, value.toString());
    }

    protected void convertChildField(Object value, AccessibleObject accessibleObject, HierarchicalStreamWriter writer, MarshallingContext context) {
        String alias = ConverterBeanUtils.getAlias(accessibleObject);
        writer.startNode(alias);
        context.convertAnother(value);
        writer.endNode();
    }

    protected void convertProperty(Object value, AccessibleObject accessibleObject, HierarchicalStreamWriter writer, MarshallingContext context) {
        JmcProperty jmcProperty = ConverterBeanUtils.getAnnotation(accessibleObject, JmcProperty.class);
        String name = null;
        if (jmcProperty == null && accessibleObject instanceof Field) {
            name = ((Field)accessibleObject).getName();
        } else if (jmcProperty != null) {
            name = jmcProperty.value();
        }
        boolean changed = false;
        if (!this.inElementConversion) {
            this.inElementConversion = true;
            changed = true;
        }
        writer.startNode(ConverterBeanUtils.getPropertyAlias(value, ConverterBeanUtils.getPropertyType(accessibleObject)));
        writer.addAttribute("name", name);
        if (value instanceof TestElementWrapper) {
            TestElementWrapper testElement = (TestElementWrapper)value;
            writer.addAttribute("elementType", testElement.getTestClassAsString());
        }
        if (value != null) {
            if (value.getClass().isEnum()) {
                context.convertAnother(ConverterBeanUtils.getEnumValue(value));
            } else if (value instanceof Variable) {
                context.convertAnother((Object)((Variable)value).getName());
            } else {
                context.convertAnother(value);
            }
        } else {
            context.convertAnother((Object)"");
        }
        writer.endNode();
        if (changed) {
            this.inElementConversion = false;
        }
    }

    protected void convertCollection(Object value, AccessibleObject accessibleObject, HierarchicalStreamWriter writer, MarshallingContext context) {
        JmcCollection annotation = ConverterBeanUtils.getAnnotation(accessibleObject, JmcCollection.class);
        if (annotation.withElementProp()) {
            writer.startNode(JMeterProperty.ELEMENT.getValue());
            if (!annotation.name().isBlank()) {
                writer.addAttribute("name", annotation.name());
            }
            if (!annotation.testname().isBlank()) {
                writer.addAttribute("testname", annotation.testname());
            }
            if (!annotation.elementType().equals(Void.class)) {
                writer.addAttribute("elementType", annotation.elementType().getSimpleName());
            }
            if (!annotation.guiclass().equals(Void.class)) {
                writer.addAttribute("guiclass", annotation.guiclass().getSimpleName());
            }
            if (!annotation.testclass().equals(Void.class)) {
                writer.addAttribute("testclass", annotation.testclass().getSimpleName());
            }
            if (annotation.enabled()) {
                writer.addAttribute("enabled", "true");
            }
        }
        writer.startNode("collectionProp");
        boolean changed = false;
        if (!this.inElementConversion) {
            this.inElementConversion = true;
            changed = true;
        }
        writer.addAttribute("name", annotation.value());
        Collection values = (Collection)value;
        if (values != null) {
            for (Object object : values) {
                TestElementWrapper testElement;
                writer.startNode(JMeterProperty.ELEMENT.getValue());
                if (object instanceof TestElementWrapper && (testElement = (TestElementWrapper)object).getTestClass() != null) {
                    writer.addAttribute("elementType", testElement.getTestClass().getSimpleName());
                }
                context.convertAnother(object);
                writer.endNode();
            }
        }
        writer.endNode();
        if (annotation.withElementProp()) {
            writer.endNode();
        }
        if (changed) {
            this.inElementConversion = false;
        }
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        return null;
    }

    public boolean canConvert(Class type) {
        return TestElementWrapper.class.isAssignableFrom(type) || "ScriptWrapper".equals(type.getClass().getSimpleName());
    }
}

