/*
 * Decompiled with CFR 0.152.
 */
package org.anasoid.jmc.core.application;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfoList;
import io.github.classgraph.ScanResult;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.anasoid.jmc.core.application.ScriptWrapper;
import org.anasoid.jmc.core.wrapper.jmeter.testelement.AbstractTestElementWrapper;
import org.anasoid.jmc.core.wrapper.jmeter.testelement.property.JMeterProperty;
import org.anasoid.jmc.core.xstream.io.xml.JmcXppDriver;
import org.apache.jmeter.samplers.SampleSaveConfiguration;
import org.apache.jmeter.save.converters.MultiPropertyConverter;
import org.apache.jmeter.save.converters.SampleSaveConfigurationConverter;
import org.apache.jmeter.save.converters.StringPropertyConverter;
import org.apache.jmeter.testelement.property.CollectionProperty;
import org.apache.jmeter.testelement.property.StringProperty;
import org.apache.jorphan.collections.HashTree;

public class JmcXstream
extends XStream {
    private static List<Class<?>> listClazz;

    public JmcXstream() {
        super((HierarchicalStreamDriver)new JmcXppDriver());
        this.setMode(1001);
        this.alias("hashTree", HashTree.class);
        ArrayList clazzs = new ArrayList();
        clazzs.add(ScriptWrapper.class);
        clazzs.addAll(JmcXstream.getProcessClazz());
        Class[] clazzArray = new Class[clazzs.size()];
        clazzArray = clazzs.toArray(clazzArray);
        this.processAnnotations(clazzArray);
        this.registerConverter((Converter)new StringPropertyConverter());
        this.alias(JMeterProperty.STRING.value, StringProperty.class);
        this.registerConverter((Converter)new MultiPropertyConverter(this.getMapper()));
        this.registerConverter((Converter)new SampleSaveConfigurationConverter(this.getMapper()));
        this.alias(SampleSaveConfiguration.class.getSimpleName(), SampleSaveConfiguration.class);
        this.addImplicitCollection(CollectionProperty.class, "value");
    }

    private static synchronized List<Class<?>> getProcessClazz() {
        if (listClazz == null) {
            try (ScanResult scanResult = new ClassGraph().enableClassInfo().rejectJars(new String[]{"gradle-*.jar", "kotlin-*.jar", "junit-*.jar", "log4j-*.jar", "jetty-*.jar", "ApacheJMeter_*-*.jar", "groovy-*.jar", "commons-*.jar", "wiremock-*.jar"}).scan();){
                ClassInfoList classInfoList = scanResult.getSubclasses(AbstractTestElementWrapper.class.getName());
                listClazz = classInfoList.stream().map(c -> c.loadClass(true)).collect(Collectors.toList());
            }
        }
        return listClazz;
    }
}

