/*
 * Decompiled with CFR 0.152.
 */
package org.anasoid.jmc.core.wrapper.jmc.functions;

import java.util.Locale;
import lombok.NonNull;
import org.anasoid.jmc.core.util.FunctionsUtils;
import org.anasoid.jmc.core.wrapper.jmc.Variable;

public final class JmeterFunctions {
    public static final String ALPHA = "abcdefghijklmnopqrstuvwxyz";
    public static final String ALPHA_UPPER = "abcdefghijklmnopqrstuvwxyz".toUpperCase(Locale.ROOT);
    public static final String NUMERIC = "0123456789";
    public static final String ALPHA_NUMERIC = "abcdefghijklmnopqrstuvwxyz0123456789";

    private JmeterFunctions() {
    }

    public static String counter(@NonNull Boolean perThread, Variable variableName) {
        if (perThread == null) {
            throw new NullPointerException("perThread is marked non-null but is null");
        }
        return FunctionsUtils.function("counter", perThread.toString().toUpperCase(Locale.ROOT), variableName);
    }

    public static String counter(@NonNull Boolean perThread) {
        if (perThread == null) {
            throw new NullPointerException("perThread is marked non-null but is null");
        }
        return JmeterFunctions.counter(perThread);
    }

    public static String eval(@NonNull String val) {
        if (val == null) {
            throw new NullPointerException("val is marked non-null but is null");
        }
        return FunctionsUtils.function("eval", val);
    }

    public static String evalVar(@NonNull Variable variable) {
        if (variable == null) {
            throw new NullPointerException("variable is marked non-null but is null");
        }
        return FunctionsUtils.function("evalVar", variable.getName());
    }

    public static String groovy(@NonNull String expression, Variable variableName) {
        if (expression == null) {
            throw new NullPointerException("expression is marked non-null but is null");
        }
        return FunctionsUtils.function("groovy", expression, variableName);
    }

    public static String groovy(@NonNull String expression) {
        if (expression == null) {
            throw new NullPointerException("expression is marked non-null but is null");
        }
        return JmeterFunctions.groovy(expression, null);
    }

    public static String isPropDefined(@NonNull String propertyName) {
        if (propertyName == null) {
            throw new NullPointerException("propertyName is marked non-null but is null");
        }
        return FunctionsUtils.function("isPropDefined", propertyName);
    }

    public static String isVarDefined(@NonNull Variable variable) {
        if (variable == null) {
            throw new NullPointerException("variable is marked non-null but is null");
        }
        return FunctionsUtils.function("isVarDefined", variable.getName());
    }

    public static String javaScript(@NonNull String expression, Variable variableName) {
        if (expression == null) {
            throw new NullPointerException("expression is marked non-null but is null");
        }
        return FunctionsUtils.function("javaScript", expression, variableName);
    }

    public static String javaScript(@NonNull String expression) {
        if (expression == null) {
            throw new NullPointerException("expression is marked non-null but is null");
        }
        return JmeterFunctions.javaScript(expression, null);
    }

    public static String jexl3(@NonNull String expression, Variable variableName) {
        if (expression == null) {
            throw new NullPointerException("expression is marked non-null but is null");
        }
        return FunctionsUtils.function("jexl3", expression, variableName);
    }

    public static String jexl3(@NonNull String expression) {
        if (expression == null) {
            throw new NullPointerException("expression is marked non-null but is null");
        }
        return JmeterFunctions.jexl3(expression, null);
    }

    public static String log(String input, String logLevel, String throwable, String comment) {
        return FunctionsUtils.function("log", input, logLevel, throwable, comment);
    }

    public static String log(String input, String logLevel, String comment) {
        return JmeterFunctions.log(input, logLevel, null, comment);
    }

    public static String log(String input, String logLevel) {
        return JmeterFunctions.log(input, logLevel, null);
    }

    public static String log(String input) {
        return JmeterFunctions.log(input, null);
    }

    public static String logn(String input, String logLevel, String throwable) {
        return FunctionsUtils.function("logn", input, logLevel, throwable);
    }

    public static String logn(String input, String logLevel) {
        return JmeterFunctions.logn(input, logLevel, null);
    }

    public static String logn(String input) {
        return JmeterFunctions.logn(input, null);
    }

    public static String machineIP() {
        return FunctionsUtils.function("machineIP", new Object[0]);
    }

    public static String machineName() {
        return FunctionsUtils.function("machineName", new Object[0]);
    }

    public static String property(@NonNull String propertyName, Variable variableName, String defaultValue) {
        if (propertyName == null) {
            throw new NullPointerException("propertyName is marked non-null but is null");
        }
        return FunctionsUtils.function("property", propertyName, variableName, defaultValue);
    }

    public static String property(@NonNull String propertyName, String defaultValue) {
        if (propertyName == null) {
            throw new NullPointerException("propertyName is marked non-null but is null");
        }
        return JmeterFunctions.property(propertyName, null, defaultValue);
    }

    public static String random(String min, String max, Variable variableName) {
        return FunctionsUtils.function("Random", min, max, variableName);
    }

    public static String random(String min, String max) {
        return JmeterFunctions.random(min, max, null);
    }

    public static String random(int min, int max, Variable variableName) {
        return JmeterFunctions.random(String.valueOf(min), String.valueOf(max), variableName);
    }

    public static String random(int min, int max) {
        return JmeterFunctions.random(min, max, null);
    }

    public static String randomAlpha(String length, Variable variableName) {
        return JmeterFunctions.randomString(length, ALPHA, variableName);
    }

    public static String randomAlpha(int length, Variable variableName) {
        return JmeterFunctions.randomAlpha(String.valueOf(length), variableName);
    }

    public static String randomAlpha(int length) {
        return JmeterFunctions.randomAlpha(String.valueOf(length), null);
    }

    public static String randomAlphaNumeric(String length, Variable variableName) {
        return JmeterFunctions.randomString(length, ALPHA_NUMERIC, variableName);
    }

    public static String randomAlphaNumeric(int length, Variable variableName) {
        return JmeterFunctions.randomAlphaNumeric(String.valueOf(length), variableName);
    }

    public static String randomAlphaNumeric(int length) {
        return JmeterFunctions.randomAlphaNumeric(String.valueOf(length), null);
    }

    public static String randomDate(String format, String startDate, @NonNull String endDate, String locale, Variable variableName) {
        if (endDate == null) {
            throw new NullPointerException("endDate is marked non-null but is null");
        }
        return FunctionsUtils.function("RandomDate", format, startDate, endDate, locale, variableName);
    }

    public static String randomDate(String format, String startDate, @NonNull String endDate, String locale) {
        if (endDate == null) {
            throw new NullPointerException("endDate is marked non-null but is null");
        }
        return JmeterFunctions.randomDate(format, startDate, endDate, locale);
    }

    public static String randomDate(String format, String startDate, @NonNull String endDate) {
        if (endDate == null) {
            throw new NullPointerException("endDate is marked non-null but is null");
        }
        return JmeterFunctions.randomDate(format, startDate, endDate);
    }

    public static String randomString(String length, String chars, Variable variableName) {
        return FunctionsUtils.function("RandomString", length, chars, variableName);
    }

    public static String randomString(String length, String chars) {
        return JmeterFunctions.randomString(length, chars, null);
    }

    public static String randomString(int length, String chars, Variable variableName) {
        return JmeterFunctions.randomString(String.valueOf(length), chars, variableName);
    }

    public static String randomString(int length, String chars) {
        return JmeterFunctions.randomString(length, chars, null);
    }

    public static String samplerName() {
        return FunctionsUtils.function("samplerName", new Object[0]);
    }

    public static String setProperty(@NonNull String propertyName, String propertyValue, Boolean returnOrigin) {
        if (propertyName == null) {
            throw new NullPointerException("propertyName is marked non-null but is null");
        }
        return FunctionsUtils.function("setProperty", propertyName, propertyValue, returnOrigin);
    }

    public static String setProperty(@NonNull String propertyName, String propertyValue) {
        if (propertyName == null) {
            throw new NullPointerException("propertyName is marked non-null but is null");
        }
        return JmeterFunctions.setProperty(propertyName, propertyValue, null);
    }

    public static String testPlanName() {
        return FunctionsUtils.function("TestPlanName", new Object[0]);
    }

    public static String threadGroupName() {
        return FunctionsUtils.function("threadGroupName", new Object[0]);
    }

    public static String threadNum() {
        return FunctionsUtils.function("threadNum", new Object[0]);
    }

    public static String time(String format, Variable variableName) {
        return FunctionsUtils.function("time", format, variableName);
    }

    public static String time(String format) {
        return JmeterFunctions.time(format, null);
    }

    public static String time() {
        return JmeterFunctions.time(null, null);
    }

    public static String timeShift(String format, String dateToShift, String valueToShift, String locale, Variable variableName) {
        return FunctionsUtils.function("timeShift", format, dateToShift, valueToShift, locale, variableName);
    }

    public static String timeShift(String format, String dateToShift, String valueToShift, String locale) {
        return JmeterFunctions.timeShift(format, dateToShift, valueToShift, locale, null);
    }

    public static String uuid() {
        return FunctionsUtils.function("UUID", new Object[0]);
    }
}

