/*
 * Decompiled with CFR 0.152.
 */
package org.anasoid.jmc.core.application.validator;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.anasoid.jmc.core.application.validator.NodeValidator;
import org.anasoid.jmc.core.application.validator.annotations.JmcChildrenTypes;
import org.anasoid.jmc.core.wrapper.jmeter.testelement.TestElementWrapper;
import org.anasoid.jmc.core.xstream.exceptions.ConversionIllegalStateException;

public class ChildrenTypeValidator
implements NodeValidator {
    public static Set<Class<?>> getTypes(TestElementWrapper<?> testElementWrapper) {
        HashSet result = new HashSet();
        for (Class<?> item = testElementWrapper.getClass(); item != Object.class; item = item.getSuperclass()) {
            JmcChildrenTypes[] jmcChildrenTypes;
            for (JmcChildrenTypes j : jmcChildrenTypes = (JmcChildrenTypes[])item.getAnnotationsByType(JmcChildrenTypes.class)) {
                result.addAll(Arrays.asList(j.type()));
            }
        }
        return result;
    }

    public void validate(TestElementWrapper testElementWrapper) throws ConversionIllegalStateException {
        List<TestElementWrapper<?>> children = testElementWrapper.getChilds();
        Set<Class<?>> types = ChildrenTypeValidator.getTypes(testElementWrapper);
        if (children != null && !types.isEmpty()) {
            for (TestElementWrapper<?> child : children) {
                if (!types.stream().noneMatch(t -> t.isAssignableFrom(child.getClass()))) continue;
                throw new ConversionIllegalStateException(MessageFormat.format("Child {0} with type {1} not valid on parent {2} with type {3}", child, child.getClass(), testElementWrapper, testElementWrapper.getClass()));
            }
        }
    }
}

