/*
 * Decompiled with CFR 0.152.
 */
package org.anasoid.jmc.core.wrapper.jmc.generic;

import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.anasoid.jmc.core.application.validator.annotations.JmcChildrenTypes;
import org.anasoid.jmc.core.wrapper.jmc.generic.AbstractJmxIncludeWrapper;
import org.anasoid.jmc.core.wrapper.jmeter.config.ConfigElementWrapper;
import org.anasoid.jmc.core.wrapper.jmeter.processor.PostProcessorWrapper;
import org.anasoid.jmc.core.wrapper.jmeter.processor.PreProcessorWrapper;
import org.anasoid.jmc.core.wrapper.jmeter.samplers.SampleListenerWrapper;
import org.anasoid.jmc.core.wrapper.jmeter.testelement.AssertionWrapper;
import org.anasoid.jmc.core.wrapper.jmeter.testelement.TestElementWrapper;
import org.anasoid.jmc.core.wrapper.jmeter.timers.TimerWrapper;
import org.anasoid.jmc.core.wrapper.template.JmcTemplate;
import org.anasoid.jmc.core.xstream.exceptions.ConversionException;

@JmcChildrenTypes(type={AssertionWrapper.class, ConfigElementWrapper.class, PreProcessorWrapper.class, PostProcessorWrapper.class, TimerWrapper.class, SampleListenerWrapper.class})
public abstract class AbstractParentJmxIncludeWrapper<T>
extends AbstractJmxIncludeWrapper<T> {
    @XStreamOmitField
    private static final long serialVersionUID = -1010535206971620483L;
    private static final Pattern REGEX = Pattern.compile("^[\\s]*(.+?)[\\s]*\\<hashTree/\\>$", 32);
    @XStreamOmitField
    private final List<TestElementWrapper<?>> childs;

    protected String cleanupChild(String raw) {
        Matcher regexMatcher = REGEX.matcher(raw);
        if (!regexMatcher.find()) {
            throw new ConversionException("If node, has already child in JMX, you can't add child in JMC, Format incorrect for node : " + raw);
        }
        String result = regexMatcher.group(1);
        return result;
    }

    @Override
    protected String cleanup(String raw) {
        String result = super.cleanup(raw);
        if (!this.childs.isEmpty()) {
            return this.cleanupChild(result);
        }
        return result;
    }

    @Override
    public List<TestElementWrapper<?>> getChilds() {
        return this.childs;
    }

    private static <T> List<TestElementWrapper<?>> $default$childs() {
        return new ArrayList();
    }

    protected AbstractParentJmxIncludeWrapper(AbstractParentJmxIncludeWrapperBuilder<T, ?, ?> b) {
        super(b);
        this.childs = b.childs$set ? b.childs$value : AbstractParentJmxIncludeWrapper.$default$childs();
    }

    public static abstract class AbstractParentJmxIncludeWrapperBuilder<T, C extends AbstractParentJmxIncludeWrapper<T>, B extends AbstractParentJmxIncludeWrapperBuilder<T, C, B>>
    extends AbstractJmxIncludeWrapper.AbstractJmxIncludeWrapperBuilder<T, C, B> {
        private boolean childs$set;
        private List<TestElementWrapper<?>> childs$value;

        protected <I extends TestElementWrapper<?>> B withChilds(Collection<I> childs) {
            for (TestElementWrapper child : childs) {
                this.withChild(child);
            }
            return (B)this.self();
        }

        protected B withChild(TestElementWrapper<?> child) {
            if (!this.childs$set) {
                this.childs$value = new ArrayList();
            }
            this.childs$value.add(child);
            this.childs$set = true;
            return (B)this.self();
        }

        public B addAssertion(AssertionWrapper<?> assertion) {
            return this.addAssertions(Arrays.asList(assertion));
        }

        public <E extends AssertionWrapper<?>> B addAssertion(JmcTemplate<E> assertion) {
            return this.addAssertion((AssertionWrapper)assertion.generate());
        }

        public B addAssertions(List<AssertionWrapper<?>> assertions) {
            return this.withChilds(assertions);
        }

        public B addConfig(ConfigElementWrapper<?> config) {
            return this.addConfigs(Arrays.asList(config));
        }

        public <E extends ConfigElementWrapper<?>> B addConfig(JmcTemplate<E> config) {
            return this.addConfig((ConfigElementWrapper)config.generate());
        }

        public B addConfigs(List<ConfigElementWrapper<?>> childs) {
            return this.withChilds(childs);
        }

        public B addPreProcessor(PreProcessorWrapper<?> preProcessor) {
            return this.addPreProcessors(Arrays.asList(preProcessor));
        }

        public <E extends PreProcessorWrapper<?>> B addPreProcessor(JmcTemplate<E> preProcessor) {
            return this.addPreProcessor((PreProcessorWrapper)preProcessor.generate());
        }

        public B addPreProcessors(List<PreProcessorWrapper<?>> childs) {
            return this.withChilds(childs);
        }

        public B addPostProcessor(PostProcessorWrapper<?> postProcessor) {
            return this.addPostProcessors(Arrays.asList(postProcessor));
        }

        public <E extends PostProcessorWrapper<?>> B addPostProcessor(JmcTemplate<E> postProcessor) {
            return this.addPostProcessor((PostProcessorWrapper)postProcessor.generate());
        }

        public B addPostProcessors(List<PostProcessorWrapper<?>> childs) {
            return this.withChilds(childs);
        }

        public B addTimer(TimerWrapper<?> timer) {
            return this.addTimers(Arrays.asList(timer));
        }

        public <E extends TimerWrapper<?>> B addTimer(JmcTemplate<E> timer) {
            return this.addTimer((TimerWrapper)timer.generate());
        }

        public B addTimers(List<TimerWrapper<?>> childs) {
            return this.withChilds(childs);
        }

        public B addListener(SampleListenerWrapper<?> listener) {
            return this.addListener(Arrays.asList(listener));
        }

        public <E extends SampleListenerWrapper<?>> B addListener(JmcTemplate<E> listener) {
            return this.addListener((SampleListenerWrapper)listener.generate());
        }

        public B addListener(List<SampleListenerWrapper<?>> childs) {
            return this.withChilds(childs);
        }

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            AbstractParentJmxIncludeWrapperBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static <T> void $fillValuesFromInstanceIntoBuilder(AbstractParentJmxIncludeWrapper<T> instance, AbstractParentJmxIncludeWrapperBuilder<T, ?, ?> b) {
            b.withChilds(instance.childs);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "AbstractParentJmxIncludeWrapper.AbstractParentJmxIncludeWrapperBuilder(super=" + super.toString() + ", childs$value=" + this.childs$value + ")";
        }
    }
}

