/*
 * Decompiled with CFR 0.152.
 */
package org.anasoid.jmc.core.xstream;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.anasoid.jmc.core.wrapper.jmc.Variable;
import org.anasoid.jmc.core.wrapper.jmeter.testelement.TestElementWrapper;
import org.anasoid.jmc.core.wrapper.jmeter.testelement.property.JMeterProperty;
import org.anasoid.jmc.core.xstream.annotations.JmcAsAttribute;
import org.anasoid.jmc.core.xstream.annotations.JmcCollection;
import org.anasoid.jmc.core.xstream.annotations.JmcEmptyAllowed;
import org.anasoid.jmc.core.xstream.annotations.JmcHiddenFields;
import org.anasoid.jmc.core.xstream.annotations.JmcInherited;
import org.anasoid.jmc.core.xstream.annotations.JmcMandatory;
import org.anasoid.jmc.core.xstream.annotations.JmcMethodAlias;
import org.anasoid.jmc.core.xstream.annotations.JmcNullAllowed;
import org.anasoid.jmc.core.xstream.annotations.JmcProperty;
import org.anasoid.jmc.core.xstream.annotations.JmcSkipDefault;
import org.anasoid.jmc.core.xstream.exceptions.ConversionException;
import org.anasoid.jmc.core.xstream.exceptions.ConversionIllegalStateException;
import org.anasoid.jmc.core.xstream.exceptions.ConversionMandatoryException;
import org.anasoid.jmc.core.xstream.types.TypeManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConverterBeanUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ConverterBeanUtils.class);

    private ConverterBeanUtils() {
    }

    public static List<Method> getMethods(Object source) {
        HashMap<String, Method> result = new HashMap<String, Method>();
        HashMap<String, Method> allMethod = new HashMap<String, Method>();
        Class<?> item = source.getClass();
        for (Class<?> clazz : ConverterBeanUtils.getSuperClasses(item)) {
            for (Method method : clazz.getDeclaredMethods()) {
                JmcMethodAlias jmcMethodAlias = ConverterBeanUtils.getAnnotation(method, JmcMethodAlias.class);
                JmcProperty jmcProperty = ConverterBeanUtils.getAnnotation(method, JmcProperty.class);
                JmcInherited jmcInherited = method.getAnnotation(JmcInherited.class);
                JmcCollection jmcCollection = method.getAnnotation(JmcCollection.class);
                if (!(jmcMethodAlias == null && jmcProperty == null && jmcInherited == null && jmcCollection == null || result.containsKey(method.getName()) || allMethod.containsKey(method.getName()))) {
                    if (method.getParameters().length > 0) {
                        throw new ConversionException("Invalid JmcMethodAlias on Method with Parameter : " + method);
                    }
                    result.put(method.getName(), method);
                    continue;
                }
                if (method.getParameters().length != 0) continue;
                allMethod.put(method.getName(), method);
            }
        }
        return new ArrayList<Method>(result.values());
    }

    public static List<Field> getFields(Object source) {
        HashMap<String, Field> result = new HashMap<String, Field>();
        Class<?> clazz = source.getClass();
        for (Class<?> sclazz : ConverterBeanUtils.getSuperClasses(clazz)) {
            for (Field field : sclazz.getDeclaredFields()) {
                if (result.containsKey(field.getName())) continue;
                result.put(field.getName(), field);
            }
        }
        return new ArrayList<Field>(result.values());
    }

    public static boolean isProperty(AccessibleObject accessibleObject) {
        JmcProperty annotation = ConverterBeanUtils.getAnnotation(accessibleObject, JmcProperty.class);
        return annotation != null;
    }

    public static <T extends Annotation> T getAnnotation(AccessibleObject accessibleObject, Class<T> annotation) {
        if (accessibleObject instanceof Method) {
            Method method = (Method)accessibleObject;
            JmcInherited jmcInherited = accessibleObject.getAnnotation(JmcInherited.class);
            if (jmcInherited != null) {
                boolean first = true;
                for (Class<?> clazz : ConverterBeanUtils.getSuperClasses(method.getDeclaringClass())) {
                    Class<?>[] interfaces;
                    if (!first) {
                        try {
                            Method superMethod = clazz.getMethod(method.getName(), new Class[0]);
                            return superMethod.getAnnotation(annotation);
                        }
                        catch (NoSuchMethodException superMethod) {
                            // empty catch block
                        }
                    }
                    first = false;
                    for (Class<?> interf : interfaces = clazz.getInterfaces()) {
                        try {
                            Method superMethod = interf.getMethod(method.getName(), new Class[0]);
                            return superMethod.getAnnotation(annotation);
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                        }
                    }
                }
            }
        }
        return accessibleObject.getAnnotation(annotation);
    }

    private static String getName(AccessibleObject accessibleObject) {
        if (accessibleObject instanceof Method) {
            Method method = (Method)accessibleObject;
            return method.getName();
        }
        if (accessibleObject instanceof Field) {
            Field field = (Field)accessibleObject;
            return field.getName();
        }
        return null;
    }

    private static Set<String> getHiddenFields(Object source) {
        HashSet<String> result = new HashSet<String>();
        if (source != null) {
            for (Class<?> item = source.getClass(); item != Object.class; item = item.getSuperclass()) {
                JmcHiddenFields jmcHiddenFields = item.getAnnotation(JmcHiddenFields.class);
                if (jmcHiddenFields == null) continue;
                result.addAll(Arrays.asList(jmcHiddenFields.value()));
            }
        }
        return result;
    }

    public static List<Class<?>> getSuperClasses(Class<?> clazz) {
        ArrayList result = new ArrayList();
        for (Class<?> item = clazz; item != Object.class; item = item.getSuperclass()) {
            result.add(item);
        }
        return result;
    }

    public static boolean isCollection(AccessibleObject field) {
        JmcCollection annotation = ConverterBeanUtils.getAnnotation(field, JmcCollection.class);
        return annotation != null;
    }

    public static Object getValue(AccessibleObject field, Object source) {
        field.setAccessible(true);
        try {
            if (field instanceof Field) {
                String fieldName = ((Field)field).getName();
                String getMethodName = "get" + fieldName.substring(0, 1).toUpperCase(Locale.ROOT) + fieldName.substring(1);
                try {
                    Method getMethod = source.getClass().getMethod(getMethodName, new Class[0]);
                    return getMethod.invoke(source, new Object[0]);
                }
                catch (NoSuchMethodException e) {
                    if (Boolean.class.equals(((Field)field).getType()) || Boolean.TYPE.equals(((Field)field).getType())) {
                        getMethodName = "is" + fieldName.substring(0, 1).toUpperCase(Locale.ROOT) + fieldName.substring(1);
                        try {
                            Method getMethod = source.getClass().getMethod(getMethodName, new Class[0]);
                            return getMethod.invoke(source, new Object[0]);
                        }
                        catch (NoSuchMethodException ex) {
                            LOG.warn("Getter not found for field {} on {}", (Object)((Field)field).getName(), source);
                            return ((Field)field).get(source);
                        }
                    }
                    LOG.warn("Getter not found for field {} on {}", (Object)((Field)field).getName(), source);
                    return ((Field)field).get(source);
                }
            }
            if (field instanceof Method) {
                return ((Method)field).invoke(source, new Object[0]);
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new ConversionException(e);
        }
        throw new ConversionException("Unknown type: " + field);
    }

    public static String getAlias(AccessibleObject accessibleObject) {
        XStreamAlias annotationXstream = ConverterBeanUtils.getAnnotation(accessibleObject, XStreamAlias.class);
        if (annotationXstream != null) {
            return annotationXstream.value();
        }
        JmcMethodAlias annotationJmc = ConverterBeanUtils.getAnnotation(accessibleObject, JmcMethodAlias.class);
        if (annotationJmc != null) {
            return annotationJmc.value();
        }
        if (accessibleObject instanceof Field) {
            return ((Field)accessibleObject).getName();
        }
        return null;
    }

    public static Class<?> getPropertyType(AccessibleObject accessibleObject) {
        JmcProperty jmcProperty = ConverterBeanUtils.getAnnotation(accessibleObject, JmcProperty.class);
        if (jmcProperty.type() != Void.class) {
            return jmcProperty.type();
        }
        if (accessibleObject instanceof Field) {
            return ((Field)accessibleObject).getType();
        }
        if (accessibleObject instanceof Method) {
            return ((Method)accessibleObject).getReturnType();
        }
        throw new ConversionIllegalStateException("Unknown accessibleObject type :" + accessibleObject);
    }

    public static String getPropertyAlias(Object value, Class<?> clazz) {
        Class<?> ppClazz;
        Class<?> clazz2 = ppClazz = clazz == Void.class && value != null ? value.getClass() : clazz;
        if (value != null && value.getClass().isEnum()) {
            Object enumValue = ConverterBeanUtils.getEnumValue(value);
            return ConverterBeanUtils.getPropertyAlias(enumValue, clazz == Void.class || clazz.isEnum() ? enumValue.getClass() : clazz);
        }
        if (TypeManager.class.isAssignableFrom(clazz)) {
            try {
                return ConverterBeanUtils.getPropertyAlias(value, ((TypeManager)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0])).getType((String)value));
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new ConversionException(e);
            }
        }
        if (ppClazz == Integer.class) {
            return JMeterProperty.INTEGER.value();
        }
        if (ppClazz == String.class) {
            return JMeterProperty.STRING.value();
        }
        if (ppClazz == Long.class) {
            return JMeterProperty.LONG.value();
        }
        if (ppClazz == Boolean.class || ppClazz == Boolean.TYPE) {
            return JMeterProperty.BOOL.value();
        }
        if (ppClazz == Float.class) {
            return JMeterProperty.FLOAT.value();
        }
        if (ppClazz == Double.class) {
            return JMeterProperty.DOUBLE.value();
        }
        if (ppClazz == Variable.class) {
            return JMeterProperty.STRING.value();
        }
        if (ppClazz.isEnum()) {
            return JMeterProperty.STRING.value();
        }
        if (value instanceof TestElementWrapper) {
            return JMeterProperty.ELEMENT.value();
        }
        throw new ConversionIllegalStateException("Unknown properties type for :" + value);
    }

    public static Object getEnumValue(Object object) {
        try {
            return object.getClass().getMethod("value", new Class[0]).invoke(object, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            return object.toString();
        }
    }

    private static boolean isHiddenField(Object source, AccessibleObject accessibleObject) {
        Set<String> hiddenFields = ConverterBeanUtils.getHiddenFields(source);
        return hiddenFields.contains(ConverterBeanUtils.getName(accessibleObject));
    }

    public static boolean shouldSkip(Object source, AccessibleObject accessibleObject) {
        if (ConverterBeanUtils.getAnnotation(accessibleObject, XStreamOmitField.class) != null) {
            return true;
        }
        Object value = ConverterBeanUtils.getValue(accessibleObject, source);
        if (ConverterBeanUtils.isHiddenField(source, accessibleObject)) {
            if (value != null) {
                throw new ConversionIllegalStateException("Field (" + accessibleObject.toString() + ") is hidden on " + source.toString() + "and should not be used");
            }
            return true;
        }
        if (value == null) {
            if (ConverterBeanUtils.getAnnotation(accessibleObject, JmcNullAllowed.class) != null) {
                return false;
            }
            if (ConverterBeanUtils.getAnnotation(accessibleObject, JmcMandatory.class) != null) {
                throw new ConversionMandatoryException(source, accessibleObject);
            }
            return true;
        }
        JmcSkipDefault jmcSkipDefault = ConverterBeanUtils.getAnnotation(accessibleObject, JmcSkipDefault.class);
        if (jmcSkipDefault != null && jmcSkipDefault.value().equals(value.toString())) {
            return true;
        }
        return value instanceof Collection && ((Collection)value).isEmpty() && ConverterBeanUtils.getAnnotation(accessibleObject, JmcEmptyAllowed.class) == null;
    }

    public static List<AccessibleObject> getAttributeOnly(List<AccessibleObject> accessibleObjects) {
        ArrayList<AccessibleObject> result = new ArrayList<AccessibleObject>();
        for (AccessibleObject accessibleObject : accessibleObjects) {
            if (!ConverterBeanUtils.isAttribute(accessibleObject)) continue;
            result.add(accessibleObject);
        }
        return result;
    }

    public static boolean isAttribute(AccessibleObject accessibleObject) {
        return ConverterBeanUtils.getAnnotation(accessibleObject, XStreamAsAttribute.class) != null || ConverterBeanUtils.getAnnotation(accessibleObject, JmcAsAttribute.class) != null;
    }
}

