/*
 * Decompiled with CFR 0.152.
 */
package org.anasoid.jmc.core.wrapper.jmeter.util;

import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.anasoid.jmc.core.config.JmcConfig;
import org.anasoid.jmc.core.util.FileUtils;
import org.anasoid.jmc.core.wrapper.jmc.script.ScriptLanguage;
import org.anasoid.jmc.core.wrapper.jmc.validator.Validator;
import org.anasoid.jmc.core.wrapper.jmeter.gui.JMeterGUIWrapper;
import org.anasoid.jmc.core.wrapper.jmeter.testelement.AbstractTestElementWrapper;
import org.anasoid.jmc.core.xstream.annotations.JmcProperty;
import org.anasoid.jmc.core.xstream.exceptions.ConversionIllegalStateException;
import org.apache.jmeter.gui.AbstractJMeterGuiComponent;
import org.apache.jmeter.util.ScriptingTestElement;

public abstract class ScriptingTestElementParentWrapper<T extends ScriptingTestElement, G extends AbstractJMeterGuiComponent>
extends AbstractTestElementWrapper<T>
implements JMeterGUIWrapper<G>,
Validator {
    @XStreamOmitField
    private final List<String> parameters;
    @JmcProperty(value="scriptLanguage")
    private final String scriptLanguage;
    @XStreamOmitField
    private final String scriptFile;
    @XStreamOmitField
    private final boolean scriptFileResource;

    @Override
    public void validate() throws ConversionIllegalStateException {
        if (this.scriptFile == null) {
            throw new ConversionIllegalStateException("ScriptFile is mandatory");
        }
    }

    @JmcProperty(value="filename")
    protected String filenameField() {
        if (this.isScriptFileResource()) {
            return "";
        }
        return JmcConfig.getScriptRootFolder() + this.scriptFile;
    }

    @JmcProperty(value="script")
    protected String scriptField() {
        if (!this.isScriptFileResource()) {
            return "";
        }
        return FileUtils.readResource(this.getScriptFile());
    }

    @JmcProperty(value="parameters")
    protected String parametersField() {
        if (this.parameters.isEmpty()) {
            return "";
        }
        return String.join((CharSequence)" ", this.parameters);
    }

    private static <T extends ScriptingTestElement, G extends AbstractJMeterGuiComponent> List<String> $default$parameters() {
        return new ArrayList<String>();
    }

    private static <T extends ScriptingTestElement, G extends AbstractJMeterGuiComponent> String $default$scriptLanguage() {
        return ScriptLanguage.GROOVY.value();
    }

    private static <T extends ScriptingTestElement, G extends AbstractJMeterGuiComponent> boolean $default$scriptFileResource() {
        return JmcConfig.isScriptResource();
    }

    protected ScriptingTestElementParentWrapper(ScriptingTestElementParentWrapperBuilder<T, G, ?, ?> b) {
        super(b);
        this.parameters = b.parameters$set ? b.parameters$value : ScriptingTestElementParentWrapper.$default$parameters();
        this.scriptLanguage = b.scriptLanguage$set ? b.scriptLanguage$value : ScriptingTestElementParentWrapper.$default$scriptLanguage();
        this.scriptFile = b.scriptFile;
        this.scriptFileResource = b.scriptFileResource$set ? b.scriptFileResource$value : ScriptingTestElementParentWrapper.$default$scriptFileResource();
    }

    public List<String> getParameters() {
        return this.parameters;
    }

    public String getScriptLanguage() {
        return this.scriptLanguage;
    }

    public String getScriptFile() {
        return this.scriptFile;
    }

    public boolean isScriptFileResource() {
        return this.scriptFileResource;
    }

    public static abstract class ScriptingTestElementParentWrapperBuilder<T extends ScriptingTestElement, G extends AbstractJMeterGuiComponent, C extends ScriptingTestElementParentWrapper<T, G>, B extends ScriptingTestElementParentWrapperBuilder<T, G, C, B>>
    extends AbstractTestElementWrapper.AbstractTestElementWrapperBuilder<T, C, B> {
        private boolean parameters$set;
        private List<String> parameters$value;
        private boolean scriptLanguage$set;
        private String scriptLanguage$value;
        private String scriptFile;
        private boolean scriptFileResource$set;
        private boolean scriptFileResource$value;

        public B withScriptLanguage(String scriptLanguage) {
            this.scriptLanguage$value = scriptLanguage;
            this.scriptLanguage$set = true;
            return (B)this.self();
        }

        public B withScriptLanguage(ScriptLanguage scriptLanguage) {
            return this.withScriptLanguage(scriptLanguage.value());
        }

        protected B withParameters(List<String> parameters) {
            this.parameters$value = parameters;
            this.parameters$set = true;
            return (B)this.self();
        }

        public B addParameters(List<String> parameters) {
            if (!this.parameters$set) {
                this.withParameters(new ArrayList<String>());
            }
            this.parameters$value.addAll(parameters);
            return (B)this.self();
        }

        public B addParameter(String parameter) {
            return this.addParameters(Arrays.asList(parameter));
        }

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            ScriptingTestElementParentWrapperBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static <T extends ScriptingTestElement, G extends AbstractJMeterGuiComponent> void $fillValuesFromInstanceIntoBuilder(ScriptingTestElementParentWrapper<T, G> instance, ScriptingTestElementParentWrapperBuilder<T, G, ?, ?> b) {
            b.withParameters(instance.parameters);
            b.withScriptLanguage(instance.scriptLanguage);
            b.withScriptFile(instance.scriptFile);
            b.withScriptFileResource(instance.scriptFileResource);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B withScriptFile(String scriptFile) {
            this.scriptFile = scriptFile;
            return (B)this.self();
        }

        public B withScriptFileResource(boolean scriptFileResource) {
            this.scriptFileResource$value = scriptFileResource;
            this.scriptFileResource$set = true;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "ScriptingTestElementParentWrapper.ScriptingTestElementParentWrapperBuilder(super=" + super.toString() + ", parameters$value=" + this.parameters$value + ", scriptLanguage$value=" + this.scriptLanguage$value + ", scriptFile=" + this.scriptFile + ", scriptFileResource$value=" + this.scriptFileResource$value + ")";
        }
    }
}

