/*
 * Decompiled with CFR 0.152.
 */
package org.anasoid.jmc.core.config;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.jmeter.save.SaveService;
import org.apache.jmeter.util.JMeterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JmcConfig {
    private static final Logger LOG = LoggerFactory.getLogger(JmcConfig.class);
    private static final String MAIN_CONFIG_FILE = "org/anasoid/jmc/core/config/jmc.properties";
    private static final String USER_CONFIG_FILE = "jmc-user.properties";
    private static final Properties properties = JmcConfig.loadJmcProperties();

    private JmcConfig() {
    }

    public static String getDataRootFolder() {
        return properties.getProperty("jmc.data.root.folder");
    }

    public static String getScriptRootFolder() {
        return properties.getProperty("jmc.script.root.folder");
    }

    public static String getResultRootFolder() {
        return properties.getProperty("jmc.result.root.folder");
    }

    public static boolean isDataResource() {
        return "true".equalsIgnoreCase(properties.getProperty("jmc.data.resource"));
    }

    public static boolean isScriptResource() {
        return "true".equalsIgnoreCase(properties.getProperty("jmc.script.resource"));
    }

    public static String getVersion() {
        return SaveService.getVERSION();
    }

    public static String getJMeterVersion() {
        return JMeterUtils.getJMeterVersion();
    }

    public static String getPropertiesVersion() {
        return properties.getProperty("jmc.jmeter.properties.version");
    }

    private static Properties loadJmcProperties() {
        Properties p = new Properties();
        LOG.info("Loading properties");
        p.putAll((Map<?, ?>)JmcConfig.loadJmcProperties(MAIN_CONFIG_FILE));
        p.putAll((Map<?, ?>)JmcConfig.loadJmcProperties(USER_CONFIG_FILE));
        p.putAll((Map<?, ?>)JmcConfig.loadJmcProperties(System.getProperties().getProperty("user.home") + File.separator + USER_CONFIG_FILE));
        p.putAll((Map<?, ?>)System.getProperties());
        return p;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Properties loadJmcProperties(String file) {
        Properties p = new Properties();
        try (InputStream is = Files.newInputStream(Paths.get(file, new String[0]), new OpenOption[0]);){
            p.load(is);
            LOG.info("Loading properties file : {}", (Object)file);
            return p;
        }
        catch (IOException e) {
            try (InputStream is2 = ClassLoader.getSystemResourceAsStream(file);){
                if (is2 == null) {
                    LOG.info("Properties file : {} Not found", (Object)file);
                    Properties properties = p;
                    return properties;
                }
                p.load(is2);
                LOG.info("Loading resource file : {}", (Object)file);
                return p;
            }
            catch (IOException ex) {
                LOG.info("Resource file : {} Not found", (Object)file);
            }
        }
        return p;
    }

    public static String getProperty(String key) {
        return properties.getProperty(key);
    }

    public static String getProperty(String key, String defaultValue) {
        return properties.getProperty(key, defaultValue);
    }

    public static Map<String, String> getPropertyPrefix(String prefix) {
        HashMap<String, String> result = new HashMap<String, String>();
        String fullPrefix = prefix + ".";
        properties.entrySet().stream().filter(c -> ((String)c.getKey()).startsWith(fullPrefix)).forEach(c -> result.put((String)c.getKey(), (String)c.getValue()));
        return result;
    }
}

