/*
 * Decompiled with CFR 0.152.
 */
package org.anasoid.jmc.core.application;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.anasoid.jmc.core.application.interceptors.PrepareInterceptor;
import org.anasoid.jmc.core.wrapper.jmeter.control.ControllerWrapper;
import org.anasoid.jmc.core.wrapper.jmeter.control.ModuleControllerWrapper;
import org.anasoid.jmc.core.wrapper.jmeter.control.TestFragmentWrapper;
import org.anasoid.jmc.core.wrapper.jmeter.testelement.AbstractTestElementWrapper;
import org.anasoid.jmc.core.wrapper.jmeter.testelement.TestElementWrapper;
import org.anasoid.jmc.core.wrapper.jmeter.testelement.TestPlanWrapper;
import org.anasoid.jmc.core.xstream.exceptions.ConversionException;
import org.apache.commons.collections.ListUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PrepareModuleControllerInterceptor
implements PrepareInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(PrepareModuleControllerInterceptor.class);

    PrepareModuleControllerInterceptor() {
    }

    @Override
    public boolean support(TestElementWrapper<?> testElementWrapper) {
        return testElementWrapper instanceof ModuleControllerWrapper;
    }

    @Override
    public void prepare(TestElementWrapper<?> testPlan, TestElementWrapper<?> testElementWrapper) {
        if (!(testPlan instanceof TestPlanWrapper)) {
            LOG.warn("Module Controller is using in test : {}", testPlan);
            return;
        }
        ModuleControllerWrapper moduleControllerWrapper = (ModuleControllerWrapper)testElementWrapper;
        List<List<AbstractTestElementWrapper<?>>> targets = this.findTarget((TestPlanWrapper)testPlan, moduleControllerWrapper.getRootParent(), moduleControllerWrapper.getModule(), new ArrayList());
        if (targets.isEmpty()) {
            throw new ConversionException("Module target not found for :" + moduleControllerWrapper.getName());
        }
        if (targets.size() > 1) {
            throw new ConversionException("Ambiguous target for :" + moduleControllerWrapper.getName());
        }
        List<AbstractTestElementWrapper<?>> target = targets.get(0);
        int nmFound = this.check(testPlan, target, 0);
        ArrayList<String> nodePath = new ArrayList<String>();
        nodePath.add("Test Plan");
        nodePath.add(((TestPlanWrapper)testPlan).getName());
        target.forEach(c -> nodePath.add(c.getName()));
        if (nmFound != 1) {
            throw new ConversionException("Duplicate module target found (" + nmFound + ") : " + moduleControllerWrapper.getName() + "->" + nodePath);
        }
        moduleControllerWrapper.setNodePath(nodePath);
    }

    protected List<List<AbstractTestElementWrapper<?>>> findTarget(TestPlanWrapper testPlan, TestFragmentWrapper testFragment, ControllerWrapper target, List<TestElementWrapper<?>> parentList) {
        ArrayList result = new ArrayList();
        List testElementLists = parentList.isEmpty() ? testPlan.getChilds().stream().filter(TestFragmentWrapper.class::isInstance).filter(c -> testFragment == null || c.equals(testFragment)).collect(Collectors.toList()) : parentList.get(parentList.size() - 1).getChilds().stream().filter(c -> c instanceof ControllerWrapper && !(c instanceof ModuleControllerWrapper)).collect(Collectors.toList());
        for (TestElementWrapper currentElement : testElementLists) {
            ArrayList currentList = new ArrayList(parentList);
            currentList.add(currentElement);
            if (currentElement == target) {
                result.add(ListUtils.sum(currentList, Arrays.asList(currentElement)));
                continue;
            }
            List<List<AbstractTestElementWrapper<?>>> childList = this.findTarget(testPlan, testFragment, target, currentList);
            childList.stream().forEach(c -> result.add(ListUtils.sum((List)currentList, (List)c)));
        }
        return result;
    }

    protected int check(TestElementWrapper root, List<AbstractTestElementWrapper<?>> target, int level) {
        AbstractTestElementWrapper<?> node = target.get(level);
        if (node.getName() == null) {
            throw new ConversionException("Illegal Name null on :" + node);
        }
        List children = root.getChilds().stream().filter(c -> c instanceof TestFragmentWrapper || c instanceof ControllerWrapper).filter(c -> StringUtils.equals((CharSequence)node.getName(), (CharSequence)((AbstractTestElementWrapper)c).getName())).collect(Collectors.toList());
        if (level + 1 == target.size()) {
            return children.size();
        }
        return children.stream().mapToInt(c -> this.check((TestElementWrapper)c, target, level + 1)).sum();
    }
}

