/*
 * Decompiled with CFR 0.152.
 */
package org.anasoid.jmc.core.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.anasoid.jmc.core.config.JmcProperties;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;

class JmcPropertiesManager
implements AutoCloseable {
    private static final ThreadLocal<List<Pair<JmcPropertiesManager, JmcProperties>>> localJmcPropertiesStack = new ThreadLocal();
    private static JmcProperties defaultJmcProperties;

    protected JmcPropertiesManager() {
        this.init(null, new String[0]);
    }

    protected JmcPropertiesManager(Map<String, String> params, String ... paths) {
        this.init(params, paths);
    }

    protected static void reset() {
        defaultJmcProperties = new JmcProperties();
        localJmcPropertiesStack.set(new ArrayList());
    }

    private void init(Map<String, String> params, String ... paths) {
        if (defaultJmcProperties == null) {
            defaultJmcProperties = new JmcProperties();
            return;
        }
        if (localJmcPropertiesStack.get() == null) {
            localJmcPropertiesStack.set(new ArrayList());
        }
        localJmcPropertiesStack.get().add(0, (Pair<JmcPropertiesManager, JmcProperties>)new MutablePair((Object)this, (Object)new JmcProperties(this.getCurrentJmcProperties(), params, paths)));
    }

    @Override
    public void close() throws Exception {
        if (CollectionUtils.isNotEmpty((Collection)localJmcPropertiesStack.get())) {
            Pair<JmcPropertiesManager, JmcProperties> pair = localJmcPropertiesStack.get().get(0);
            if (!((JmcPropertiesManager)pair.getLeft()).equals(this)) {
                throw new IllegalStateException("JMC Properties is closed by different level");
            }
        } else {
            throw new IllegalStateException("JMC Properties is already closed");
        }
        localJmcPropertiesStack.get().remove(0);
    }

    protected final JmcProperties getCurrentJmcProperties() {
        if (CollectionUtils.isNotEmpty((Collection)localJmcPropertiesStack.get())) {
            return (JmcProperties)localJmcPropertiesStack.get().get(0).getRight();
        }
        return defaultJmcProperties;
    }
}

