/*
 * Decompiled with CFR 0.152.
 */
package org.anasoid.jmc.core.wrapper.jmeter.visualizers.backend;

import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.anasoid.jmc.core.wrapper.jmc.Variable;
import org.anasoid.jmc.core.wrapper.jmc.validator.Validator;
import org.anasoid.jmc.core.wrapper.jmeter.config.ArgumentWrapper;
import org.anasoid.jmc.core.wrapper.jmeter.gui.JMeterGUIWrapper;
import org.anasoid.jmc.core.wrapper.jmeter.samplers.SampleListenerWrapper;
import org.anasoid.jmc.core.wrapper.jmeter.testelement.basic.AbstractBasicChildTestElementWrapper;
import org.anasoid.jmc.core.wrapper.jmeter.visualizers.backend.BackendListenerClient;
import org.anasoid.jmc.core.xstream.annotations.JmcCollection;
import org.anasoid.jmc.core.xstream.annotations.JmcDefaultName;
import org.anasoid.jmc.core.xstream.annotations.JmcEmptyAllowed;
import org.anasoid.jmc.core.xstream.annotations.JmcMandatory;
import org.anasoid.jmc.core.xstream.annotations.JmcProperty;
import org.anasoid.jmc.core.xstream.annotations.JmcSkipDefault;
import org.anasoid.jmc.core.xstream.exceptions.ConversionIllegalStateException;
import org.apache.jmeter.config.Arguments;
import org.apache.jmeter.config.gui.ArgumentsPanel;
import org.apache.jmeter.visualizers.backend.BackendListener;
import org.apache.jmeter.visualizers.backend.BackendListenerGui;

@JmcDefaultName(value="Backend Listener")
public class BackendListenerWrapper
extends AbstractBasicChildTestElementWrapper<BackendListener>
implements JMeterGUIWrapper<BackendListenerGui>,
SampleListenerWrapper<BackendListener>,
Validator {
    @XStreamOmitField
    private final String className;
    @XStreamOmitField
    private final BackendListenerClient implementation;
    @XStreamOmitField
    private final Map<String, String> arguments;
    @JmcProperty(value="QUEUE_SIZE")
    @JmcSkipDefault(value="5000")
    private String queueSize;

    @JmcProperty(value="classname")
    @JmcMandatory
    protected String classNameProp() {
        if (this.className != null) {
            return this.className;
        }
        return this.implementation.value();
    }

    @JmcCollection(value="Arguments.arguments", withElementProp=true, name="arguments", elementType=Arguments.class, guiclass=ArgumentsPanel.class, testclass=Arguments.class)
    @JmcEmptyAllowed
    protected List<ArgumentWrapper> argumentsProp() {
        HashMap<String, String> argumentsMap = new HashMap<String, String>();
        if (this.implementation != null) {
            argumentsMap.putAll(this.implementation.defaultValue());
        }
        argumentsMap.putAll(this.getArguments());
        return argumentsMap.entrySet().stream().map(c -> ((ArgumentWrapper.ArgumentWrapperBuilder)((ArgumentWrapper.ArgumentWrapperBuilder)ArgumentWrapper.builder().withName((String)c.getKey())).withValue((String)c.getValue())).build()).collect(Collectors.toList());
    }

    @Override
    public Class<?> getGuiClass() {
        return BackendListenerGui.class;
    }

    @Override
    public Class<?> getTestClass() {
        return BackendListener.class;
    }

    @Override
    public void validate() throws ConversionIllegalStateException {
        if (this.implementation == null && this.className == null) {
            throw new ConversionIllegalStateException("implementation is empty");
        }
    }

    private static Map<String, String> $default$arguments() {
        return new HashMap<String, String>();
    }

    private static String $default$queueSize() {
        return "5000";
    }

    protected BackendListenerWrapper(BackendListenerWrapperBuilder<?, ?> b) {
        super(b);
        this.className = b.className;
        this.implementation = b.implementation;
        this.arguments = b.arguments$set ? b.arguments$value : BackendListenerWrapper.$default$arguments();
        this.queueSize = b.queueSize$set ? b.queueSize$value : BackendListenerWrapper.$default$queueSize();
    }

    public static BackendListenerWrapperBuilder<?, ?> builder() {
        return new BackendListenerWrapperBuilderImpl();
    }

    public BackendListenerWrapperBuilder<?, ?> toBuilder() {
        return new BackendListenerWrapperBuilderImpl().$fillValuesFrom(this);
    }

    public String getClassName() {
        return this.className;
    }

    public BackendListenerClient getImplementation() {
        return this.implementation;
    }

    public Map<String, String> getArguments() {
        return this.arguments;
    }

    public String getQueueSize() {
        return this.queueSize;
    }

    public void setQueueSize(String queueSize) {
        this.queueSize = queueSize;
    }

    private static final class BackendListenerWrapperBuilderImpl
    extends BackendListenerWrapperBuilder<BackendListenerWrapper, BackendListenerWrapperBuilderImpl> {
        private BackendListenerWrapperBuilderImpl() {
        }

        @Override
        protected BackendListenerWrapperBuilderImpl self() {
            return this;
        }

        @Override
        public BackendListenerWrapper build() {
            return new BackendListenerWrapper(this);
        }
    }

    public static abstract class BackendListenerWrapperBuilder<C extends BackendListenerWrapper, B extends BackendListenerWrapperBuilder<C, B>>
    extends AbstractBasicChildTestElementWrapper.AbstractBasicChildTestElementWrapperBuilder<BackendListener, C, B> {
        private String className;
        private BackendListenerClient implementation;
        private boolean arguments$set;
        private Map<String, String> arguments$value;
        private boolean queueSize$set;
        private String queueSize$value;

        public B withQueueSize(String queueSize) {
            this.queueSize$value = queueSize;
            this.queueSize$set = true;
            return (B)this.self();
        }

        public B withQueueSize(Variable variable) {
            return this.withQueueSize(variable.getValue());
        }

        public B withQueueSize(Integer queueSize) {
            return this.withQueueSize(String.valueOf(queueSize));
        }

        public B withImplementation(BackendListenerClient implementation) {
            this.implementation = implementation;
            this.className = null;
            return (B)this.self();
        }

        public B withImplementation(String className) {
            return this.withClassName(className);
        }

        protected B withClassName(String className) {
            this.className = className;
            this.implementation = null;
            return (B)this.self();
        }

        protected B withArguments(Map<String, String> arguments) {
            this.arguments$value = arguments;
            return (B)this.self();
        }

        public B addArguments(Map<String, String> arguments) {
            if (!this.arguments$set) {
                this.withArguments(new HashMap<String, String>());
            }
            this.arguments$value.putAll(arguments);
            this.arguments$set = true;
            return (B)this.self();
        }

        public B addArgument(String name, String value) {
            this.addArguments(Map.of(name, value));
            return (B)this.self();
        }

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            BackendListenerWrapperBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(BackendListenerWrapper instance, BackendListenerWrapperBuilder<?, ?> b) {
            b.withClassName(instance.className);
            b.withImplementation(instance.implementation);
            b.withArguments(instance.arguments);
            b.withQueueSize(instance.queueSize);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "BackendListenerWrapper.BackendListenerWrapperBuilder(super=" + super.toString() + ", className=" + this.className + ", implementation=" + this.implementation + ", arguments$value=" + this.arguments$value + ", queueSize$value=" + this.queueSize$value + ")";
        }
    }
}

