/*
 * Decompiled with CFR 0.152.
 */
package org.anasoid.jmc.core.wrapper.jmc.generic;

import com.thoughtworks.xstream.annotations.XStreamConverter;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.anasoid.jmc.core.util.FileUtils;
import org.anasoid.jmc.core.wrapper.jmeter.testelement.TestElementWrapper;
import org.anasoid.jmc.core.xstream.ConverterBeanUtils;
import org.anasoid.jmc.core.xstream.annotations.JmcParam;
import org.anasoid.jmc.core.xstream.converters.TestElementConverter;
import org.anasoid.jmc.core.xstream.exceptions.ConversionException;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

@XStreamConverter(value=TestElementConverter.class)
public abstract class AbstractJmxIncludeWrapper<T>
implements TestElementWrapper<T> {
    private static final long serialVersionUID = 2424752951957768877L;
    private static final Pattern REGEX = Pattern.compile("<jmeterTestPlan\\s+(:?[a-zA-Z]+=\".{3,5}\"\\s*){3}>[\\s]*<hashTree>[\\s]*(?<node>\\<.+?\\>)[\\s]*</hashTree>[\\s]*</jmeterTestPlan>", 32);
    @XStreamOmitField
    private Set<String> tags = new HashSet<String>();
    private boolean isInitialized;
    private String path = this.getDefaultPath();
    private Map<String, String> params = new HashMap<String, String>();

    protected AbstractJmxIncludeWrapper(AbstractJmxIncludeWrapperBuilder<T, ?, ?> b) {
        this.path = b.pathSet ? b.pathValue : this.getDefaultPath();
        this.tags = b.tagsSet ? b.tagsValue : new HashSet<String>();
        this.params = b.params;
    }

    protected String getDefaultPath() {
        return null;
    }

    public String toXml() {
        if (this.getDefaultPath() != null && !this.getDefaultPath().equals(this.path)) {
            throw new ConversionException("Path [" + this.path + "]+ is provided and  getDefaultPath  for :" + this);
        }
        String raw = FileUtils.readResource(this.path);
        return this.replaceParam(this.cleanup(raw));
    }

    @Override
    public Set<String> getTags() {
        return this.tags;
    }

    protected String replaceParam(String raw) {
        HashMap<String, String> allParam = new HashMap<String, String>(this.params);
        allParam.putAll(this.getFieldParam());
        if (MapUtils.isEmpty(allParam)) {
            return raw;
        }
        String result = raw;
        for (Map.Entry entry : allParam.entrySet()) {
            result = StringUtils.replace((String)result, (String)this.getParam((String)entry.getKey()), (String)((String)entry.getValue()));
        }
        return result;
    }

    protected String getParam(String key) {
        return "${jmc." + key + "}";
    }

    protected String cleanup(String raw) {
        String result;
        Matcher regexMatcher = REGEX.matcher(raw);
        if (regexMatcher.find()) {
            result = regexMatcher.group("node");
            if (result == null) {
                throw new ConversionException("Format incorrect for node : " + raw);
            }
        } else {
            throw new ConversionException("Format incorrect for node : " + raw);
        }
        return result;
    }

    private Map<String, String> getFieldParam() {
        HashMap<String, String> result = new HashMap<String, String>();
        Class<?> clazz = this.getClass();
        for (Class<?> sclazz : ConverterBeanUtils.getSuperClasses(clazz)) {
            for (Field field : sclazz.getDeclaredFields()) {
                JmcParam jmcParam;
                if (result.containsKey(field.getName()) || (jmcParam = field.getAnnotation(JmcParam.class)) == null) continue;
                String key = field.getName();
                if (!"".equals(jmcParam.value())) {
                    key = jmcParam.value();
                }
                field.setAccessible(true);
                Object value = field.get(this);
                if (value == null) {
                    throw new ConversionException("Null value for " + field.getName() + "on " + this);
                }
                result.put(key, value.toString());
            }
        }
        return result;
    }

    @Override
    public final void init() {
        if (!this.isInitialized) {
            this.internalInit();
            this.isInitialized = true;
        }
    }

    protected void internalInit() {
    }

    @Override
    public Class<T> getTestClass() {
        return null;
    }

    @Override
    public String getTestClassAsString() {
        return null;
    }

    @Override
    public List<TestElementWrapper<?>> getChildren() {
        return null;
    }

    public String getPath() {
        return this.path;
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public static abstract class AbstractJmxIncludeWrapperBuilder<T, C extends AbstractJmxIncludeWrapper<T>, B extends AbstractJmxIncludeWrapperBuilder<T, C, B>> {
        private String pathValue;
        private boolean pathSet;
        private Set<String> tagsValue;
        private boolean tagsSet;
        private Map<String, String> params = new HashMap<String, String>();

        private static <T> void $fillValuesFromInstanceIntoBuilder(AbstractJmxIncludeWrapper<T> instance, AbstractJmxIncludeWrapperBuilder<T, ?, ?> b) {
            b.withPath(instance.path);
            b.withParams(instance.params);
            b.withTags(instance.tags);
        }

        protected B withTags(Set<String> tags) {
            this.tagsValue = tags;
            this.tagsSet = true;
            return this.self();
        }

        public B addTags(String ... tags) {
            if (this.tagsValue == null) {
                this.tagsValue = new HashSet<String>();
                this.tagsSet = true;
            }
            for (String tag : tags) {
                this.tagsValue.add(tag);
            }
            return this.self();
        }

        public B withPath(String path) {
            this.pathValue = path;
            this.pathSet = true;
            return this.self();
        }

        protected B withParams(Map<String, String> params) {
            this.params = params;
            return this.self();
        }

        public B addParams(Map<String, String> params) {
            if (this.params == null) {
                this.params = new HashMap<String, String>();
            }
            this.params.putAll(params);
            return this.self();
        }

        public B addParam(String key, String value) {
            return this.addParams(Map.of(key, value));
        }

        protected B $fillValuesFrom(C instance) {
            AbstractJmxIncludeWrapperBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return this.self();
        }

        protected abstract B self();

        public abstract C build();

        public String toString() {
            return "AbstractJmxIncludeWrapper.AbstractJmxIncludeWrapperBuilder(path$value=" + this.pathValue + ", params=" + this.params + ")";
        }
    }
}

