/*
 * Decompiled with CFR 0.152.
 */
package org.anasoid.jmc.core.wrapper.jmeter.extractor.json.jsonpath;

import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.anasoid.jmc.core.wrapper.jmc.Variable;
import org.anasoid.jmc.core.wrapper.jmc.validator.Validator;
import org.anasoid.jmc.core.wrapper.jmeter.processor.PostProcessorWrapper;
import org.anasoid.jmc.core.wrapper.jmeter.testelement.AbstractScopedTestElementWrapper;
import org.anasoid.jmc.core.xstream.annotations.JmcDefaultName;
import org.anasoid.jmc.core.xstream.annotations.JmcMandatory;
import org.anasoid.jmc.core.xstream.annotations.JmcNullAllowed;
import org.anasoid.jmc.core.xstream.annotations.JmcProperty;
import org.anasoid.jmc.core.xstream.annotations.JmcSkipDefault;
import org.anasoid.jmc.core.xstream.exceptions.ConversionIllegalStateException;
import org.anasoid.jmc.core.xstream.exceptions.ConversionMandatoryException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.jmeter.extractor.json.jsonpath.JSONPostProcessor;
import org.apache.jmeter.extractor.json.jsonpath.gui.JSONPostProcessorGui;

@JmcDefaultName(value="JSON Extractor")
public class JSONPostProcessorWrapper
extends AbstractScopedTestElementWrapper<JSONPostProcessor, JSONPostProcessorGui>
implements PostProcessorWrapper<JSONPostProcessor>,
Validator {
    @XStreamOmitField
    private List<String> jsonPathExprs;
    @XStreamOmitField
    private List<Variable> referenceNames;
    @JmcProperty(value="JSONPostProcessor.match_numbers")
    @JmcNullAllowed
    private String matchNumber;
    @XStreamOmitField
    private List<String> defaultValues;
    @JmcProperty(value="JSONPostProcessor.compute_concat")
    @JmcSkipDefault(value="false")
    private boolean computeConcat;

    @JmcProperty(value="JSONPostProcessor.jsonPathExprs")
    @JmcMandatory
    protected String jsonPathExprsProp() {
        if (CollectionUtils.isEmpty(this.jsonPathExprs)) {
            return null;
        }
        return String.join((CharSequence)";", this.jsonPathExprs);
    }

    @JmcProperty(value="JSONPostProcessor.referenceNames")
    @JmcMandatory
    protected String referenceNamesProp() {
        if (CollectionUtils.isEmpty(this.referenceNames)) {
            return null;
        }
        return String.join((CharSequence)";", this.referenceNames.stream().map(Variable::getName).collect(Collectors.toList()));
    }

    @JmcProperty(value="JSONPostProcessor.defaultValues")
    protected String defaultValuesProp() {
        if (CollectionUtils.isEmpty(this.defaultValues)) {
            return null;
        }
        return String.join((CharSequence)";", this.defaultValues);
    }

    @Override
    public Class<?> getGuiClass() {
        return JSONPostProcessorGui.class;
    }

    @Override
    public Class<?> getTestClass() {
        return JSONPostProcessor.class;
    }

    @Override
    public void validate() throws ConversionIllegalStateException {
        if (CollectionUtils.isEmpty(this.referenceNames)) {
            throw new ConversionMandatoryException((Object)this, "referenceNames");
        }
        if (CollectionUtils.isEmpty(this.jsonPathExprs)) {
            throw new ConversionMandatoryException((Object)this, "referenceNames");
        }
        if (this.jsonPathExprs.size() != this.referenceNames.size()) {
            throw new ConversionIllegalStateException("size of jsonPathExprs [" + this.jsonPathExprs + "] and referenceNames [" + this.referenceNames + "] not equal");
        }
        if (this.defaultValues != null && this.defaultValues.size() != this.referenceNames.size()) {
            throw new ConversionIllegalStateException("size of defaultValues [" + this.defaultValues + "] and referenceNames [" + this.referenceNames + "] not equal");
        }
    }

    private static boolean $default$computeConcat() {
        return false;
    }

    protected JSONPostProcessorWrapper(JSONPostProcessorWrapperBuilder<?, ?> b) {
        super(b);
        this.jsonPathExprs = b.jsonPathExprs;
        this.referenceNames = b.referenceNames;
        this.matchNumber = b.matchNumber;
        this.defaultValues = b.defaultValues;
        this.computeConcat = b.computeConcat$set ? b.computeConcat$value : JSONPostProcessorWrapper.$default$computeConcat();
    }

    public static JSONPostProcessorWrapperBuilder<?, ?> builder() {
        return new JSONPostProcessorWrapperBuilderImpl();
    }

    public JSONPostProcessorWrapperBuilder<?, ?> toBuilder() {
        return new JSONPostProcessorWrapperBuilderImpl().$fillValuesFrom(this);
    }

    public List<String> getJsonPathExprs() {
        return this.jsonPathExprs;
    }

    public void setJsonPathExprs(List<String> jsonPathExprs) {
        this.jsonPathExprs = jsonPathExprs;
    }

    public List<Variable> getReferenceNames() {
        return this.referenceNames;
    }

    public void setReferenceNames(List<Variable> referenceNames) {
        this.referenceNames = referenceNames;
    }

    public String getMatchNumber() {
        return this.matchNumber;
    }

    public void setMatchNumber(String matchNumber) {
        this.matchNumber = matchNumber;
    }

    public List<String> getDefaultValues() {
        return this.defaultValues;
    }

    public void setDefaultValues(List<String> defaultValues) {
        this.defaultValues = defaultValues;
    }

    public boolean isComputeConcat() {
        return this.computeConcat;
    }

    public void setComputeConcat(boolean computeConcat) {
        this.computeConcat = computeConcat;
    }

    private static final class JSONPostProcessorWrapperBuilderImpl
    extends JSONPostProcessorWrapperBuilder<JSONPostProcessorWrapper, JSONPostProcessorWrapperBuilderImpl> {
        private JSONPostProcessorWrapperBuilderImpl() {
        }

        @Override
        protected JSONPostProcessorWrapperBuilderImpl self() {
            return this;
        }

        @Override
        public JSONPostProcessorWrapper build() {
            return new JSONPostProcessorWrapper(this);
        }
    }

    public static abstract class JSONPostProcessorWrapperBuilder<C extends JSONPostProcessorWrapper, B extends JSONPostProcessorWrapperBuilder<C, B>>
    extends AbstractScopedTestElementWrapper.AbstractScopedTestElementWrapperBuilder<JSONPostProcessor, JSONPostProcessorGui, C, B> {
        private List<String> jsonPathExprs;
        private List<Variable> referenceNames;
        private String matchNumber;
        private List<String> defaultValues;
        private boolean computeConcat$set;
        private boolean computeConcat$value;

        protected B withReferenceNames(List<Variable> referenceNames) {
            this.referenceNames = referenceNames;
            return (B)this.self();
        }

        public B addReferenceNames(List<Variable> variables) {
            if (this.referenceNames == null) {
                this.withReferenceNames(new ArrayList<Variable>());
            }
            this.referenceNames.addAll(variables);
            return (B)this.self();
        }

        public B addReferenceName(Variable variable) {
            return this.addReferenceNames(Arrays.asList(variable));
        }

        protected B withDefaultValues(List<String> defaultValues) {
            this.defaultValues = defaultValues;
            return (B)this.self();
        }

        public B addDefaultValues(List<String> defaults) {
            if (this.defaultValues == null) {
                this.withDefaultValues(new ArrayList<String>());
            }
            this.defaultValues.addAll(defaults);
            return (B)this.self();
        }

        public B addDefaultValue(String value) {
            return this.addDefaultValues(Arrays.asList(value));
        }

        protected B withJsonPathExprs(List<String> jsonPathExprs) {
            this.jsonPathExprs = jsonPathExprs;
            return (B)this.self();
        }

        public B addJsonPathExprs(List<String> defaults) {
            if (this.jsonPathExprs == null) {
                this.withJsonPathExprs(new ArrayList<String>());
            }
            this.jsonPathExprs.addAll(defaults);
            return (B)this.self();
        }

        public B addJsonPathExpr(String value) {
            return this.addJsonPathExprs(Arrays.asList(value));
        }

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            JSONPostProcessorWrapperBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(JSONPostProcessorWrapper instance, JSONPostProcessorWrapperBuilder<?, ?> b) {
            b.withJsonPathExprs(instance.jsonPathExprs);
            b.withReferenceNames(instance.referenceNames);
            b.withMatchNumber(instance.matchNumber);
            b.withDefaultValues(instance.defaultValues);
            b.withComputeConcat(instance.computeConcat);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B withMatchNumber(String matchNumber) {
            this.matchNumber = matchNumber;
            return (B)this.self();
        }

        public B withComputeConcat(boolean computeConcat) {
            this.computeConcat$value = computeConcat;
            this.computeConcat$set = true;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "JSONPostProcessorWrapper.JSONPostProcessorWrapperBuilder(super=" + super.toString() + ", jsonPathExprs=" + this.jsonPathExprs + ", referenceNames=" + this.referenceNames + ", matchNumber=" + this.matchNumber + ", defaultValues=" + this.defaultValues + ", computeConcat$value=" + this.computeConcat$value + ")";
        }
    }
}

