/*
 * Decompiled with CFR 0.152.
 */
package org.anasoid.jmc.core.wrapper.jmeter.protocol.http.control;

import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.anasoid.jmc.core.wrapper.jmeter.config.ConfigTestElementWrapper;
import org.anasoid.jmc.core.wrapper.jmeter.protocol.http.control.AuthorizationWrapper;
import org.anasoid.jmc.core.xstream.annotations.JmcCollection;
import org.anasoid.jmc.core.xstream.annotations.JmcDefaultName;
import org.anasoid.jmc.core.xstream.annotations.JmcEmptyAllowed;
import org.anasoid.jmc.core.xstream.annotations.JmcProperty;
import org.anasoid.jmc.core.xstream.annotations.JmcSkipDefault;
import org.anasoid.jmc.core.xstream.exceptions.ConversionIllegalStateException;
import org.apache.jmeter.protocol.http.control.AuthManager;
import org.apache.jmeter.protocol.http.gui.AuthPanel;

@JmcDefaultName(value="HTTP Authorization Manager")
public class AuthManagerWrapper
extends ConfigTestElementWrapper<AuthManager, AuthPanel> {
    @XStreamOmitField
    private static final long serialVersionUID = 4261318150151324005L;
    @JmcCollection(value="AuthManager.auth_list")
    @JmcEmptyAllowed
    private final List<AuthorizationWrapper> authorizations;
    @JmcProperty(value="AuthManager.clearEachIteration")
    @JmcSkipDefault(value="false")
    private boolean clearEachIteration;
    @JmcProperty(value="AuthManager.controlledByThreadGroup")
    private boolean controlledByThread;

    @Override
    public Class<?> getGuiClass() {
        return AuthPanel.class;
    }

    @Override
    public Class<?> getTestClass() {
        return AuthManager.class;
    }

    private static List<AuthorizationWrapper> $default$authorizations() {
        return new ArrayList<AuthorizationWrapper>();
    }

    private static boolean $default$clearEachIteration() {
        return false;
    }

    private static boolean $default$controlledByThread() {
        return false;
    }

    protected AuthManagerWrapper(AuthManagerWrapperBuilder<?, ?> b) {
        super(b);
        this.authorizations = b.authorizations$set ? b.authorizations$value : AuthManagerWrapper.$default$authorizations();
        this.clearEachIteration = b.clearEachIteration$set ? b.clearEachIteration$value : AuthManagerWrapper.$default$clearEachIteration();
        this.controlledByThread = b.controlledByThread$set ? b.controlledByThread$value : AuthManagerWrapper.$default$controlledByThread();
    }

    public static AuthManagerWrapperBuilder<?, ?> builder() {
        return new AuthManagerWrapperBuilderImpl();
    }

    public AuthManagerWrapperBuilder<?, ?> toBuilder() {
        return new AuthManagerWrapperBuilderImpl().$fillValuesFrom(this);
    }

    public List<AuthorizationWrapper> getAuthorizations() {
        return this.authorizations;
    }

    public boolean isClearEachIteration() {
        return this.clearEachIteration;
    }

    public void setClearEachIteration(boolean clearEachIteration) {
        this.clearEachIteration = clearEachIteration;
    }

    public boolean isControlledByThread() {
        return this.controlledByThread;
    }

    public void setControlledByThread(boolean controlledByThread) {
        this.controlledByThread = controlledByThread;
    }

    private static final class AuthManagerWrapperBuilderImpl
    extends AuthManagerWrapperBuilder<AuthManagerWrapper, AuthManagerWrapperBuilderImpl> {
        private AuthManagerWrapperBuilderImpl() {
        }

        @Override
        protected AuthManagerWrapperBuilderImpl self() {
            return this;
        }

        @Override
        public AuthManagerWrapper build() {
            return new AuthManagerWrapper(this);
        }
    }

    public static abstract class AuthManagerWrapperBuilder<C extends AuthManagerWrapper, B extends AuthManagerWrapperBuilder<C, B>>
    extends ConfigTestElementWrapper.ConfigTestElementWrapperBuilder<AuthManager, AuthPanel, C, B> {
        private boolean authorizations$set;
        private List<AuthorizationWrapper> authorizations$value;
        private boolean clearEachIteration$set;
        private boolean clearEachIteration$value;
        private boolean controlledByThread$set;
        private boolean controlledByThread$value;

        public B withClearEachIteration(boolean clearEachIteration) {
            if (this.controlledByThread$value) {
                throw new ConversionIllegalStateException("When using controlledByThread, clearEachIteration should not be used");
            }
            this.clearEachIteration$value = clearEachIteration;
            this.clearEachIteration$set = true;
            return (B)this.self();
        }

        public B withControlledByThread(boolean controlledByThread) {
            if (controlledByThread && this.clearEachIteration$set) {
                throw new ConversionIllegalStateException("When using controlledByThread, clearEachIteration should not be used");
            }
            if (controlledByThread) {
                this.withClearEachIteration(false);
            }
            this.controlledByThread$value = controlledByThread;
            this.controlledByThread$set = true;
            return (B)this.self();
        }

        protected B withAuthorizations(List<AuthorizationWrapper> authorizations) {
            this.authorizations$value = authorizations;
            this.authorizations$set = true;
            return (B)this.self();
        }

        public B addAuthorizations(List<AuthorizationWrapper> authorizations) {
            this.authorizations$set = true;
            if (this.authorizations$value == null) {
                this.authorizations$value = new ArrayList<AuthorizationWrapper>();
            }
            this.authorizations$value.addAll(authorizations);
            return (B)this.self();
        }

        public B addAuthorization(AuthorizationWrapper authorization) {
            return this.addAuthorizations(Arrays.asList(authorization));
        }

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            AuthManagerWrapperBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(AuthManagerWrapper instance, AuthManagerWrapperBuilder<?, ?> b) {
            b.withAuthorizations(instance.authorizations);
            b.withClearEachIteration(instance.clearEachIteration);
            b.withControlledByThread(instance.controlledByThread);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "AuthManagerWrapper.AuthManagerWrapperBuilder(super=" + super.toString() + ", authorizations$value=" + this.authorizations$value + ", clearEachIteration$value=" + this.clearEachIteration$value + ", controlledByThread$value=" + this.controlledByThread$value + ")";
        }
    }
}

