/*
 * Decompiled with CFR 0.152.
 */
package org.anasoid.jmc.core.wrapper.jmeter.threads;

import com.thoughtworks.xstream.annotations.XStreamOmitField;
import org.anasoid.jmc.core.wrapper.jmc.Variable;
import org.anasoid.jmc.core.wrapper.jmeter.control.LoopControllerWrapper;
import org.anasoid.jmc.core.wrapper.jmeter.threads.AbstractThreadGroupWrapper;
import org.anasoid.jmc.core.xstream.annotations.JmcDefaultName;
import org.anasoid.jmc.core.xstream.annotations.JmcNullAllowed;
import org.anasoid.jmc.core.xstream.annotations.JmcProperty;
import org.anasoid.jmc.core.xstream.annotations.JmcSkipDefault;
import org.apache.jmeter.threads.ThreadGroup;
import org.apache.jmeter.threads.gui.ThreadGroupGui;

@JmcDefaultName(value="Thread Group")
public class ThreadGroupWrapper
extends AbstractThreadGroupWrapper<ThreadGroup, ThreadGroupGui> {
    @XStreamOmitField
    private static final long serialVersionUID = -5025050304929170782L;
    @JmcProperty(value="ThreadGroup.delay")
    @JmcNullAllowed
    private String delay;
    @JmcProperty(value="ThreadGroup.ramp_time")
    private String rampUp;
    @XStreamOmitField
    private String loops;
    @XStreamOmitField
    private Boolean continueForever;
    @JmcProperty(value="ThreadGroup.scheduler")
    private Boolean scheduler;
    @JmcProperty(value="ThreadGroup.delayedStart")
    @JmcSkipDefault(value="false")
    private Boolean delayedStartup;
    @JmcProperty(value="ThreadGroup.duration")
    @JmcNullAllowed
    private String duration;

    @Override
    public void internalInit() {
        super.internalInit();
        Object samplerControllerBuilder = LoopControllerWrapper.builder().withContinueForever(false);
        if (Boolean.TRUE.equals(this.continueForever)) {
            ((LoopControllerWrapper.LoopControllerWrapperBuilder)samplerControllerBuilder).withLoops(-1);
        } else {
            ((LoopControllerWrapper.LoopControllerWrapperBuilder)samplerControllerBuilder).withLoops(this.loops);
        }
        this.samplerController = ((LoopControllerWrapper.LoopControllerWrapperBuilder)samplerControllerBuilder).build();
    }

    @Override
    public Class<?> getTestClass() {
        return ThreadGroup.class;
    }

    @Override
    public Class<?> getGuiClass() {
        return ThreadGroupGui.class;
    }

    private static String $default$rampUp() {
        return "1";
    }

    private static String $default$loops() {
        return "1";
    }

    private static Boolean $default$continueForever() {
        return false;
    }

    private static Boolean $default$scheduler() {
        return false;
    }

    private static Boolean $default$delayedStartup() {
        return false;
    }

    protected ThreadGroupWrapper(ThreadGroupWrapperBuilder<?, ?> b) {
        super(b);
        this.delay = b.delay;
        this.rampUp = b.rampUp$set ? b.rampUp$value : ThreadGroupWrapper.$default$rampUp();
        this.loops = b.loops$set ? b.loops$value : ThreadGroupWrapper.$default$loops();
        this.continueForever = b.continueForever$set ? b.continueForever$value : ThreadGroupWrapper.$default$continueForever();
        this.scheduler = b.scheduler$set ? b.scheduler$value : ThreadGroupWrapper.$default$scheduler();
        this.delayedStartup = b.delayedStartup$set ? b.delayedStartup$value : ThreadGroupWrapper.$default$delayedStartup();
        this.duration = b.duration;
    }

    public static ThreadGroupWrapperBuilder<?, ?> builder() {
        return new ThreadGroupWrapperBuilderImpl();
    }

    public ThreadGroupWrapperBuilder<?, ?> toBuilder() {
        return new ThreadGroupWrapperBuilderImpl().$fillValuesFrom(this);
    }

    public String getDelay() {
        return this.delay;
    }

    public void setDelay(String delay) {
        this.delay = delay;
    }

    public String getRampUp() {
        return this.rampUp;
    }

    public void setRampUp(String rampUp) {
        this.rampUp = rampUp;
    }

    public String getLoops() {
        return this.loops;
    }

    public void setLoops(String loops) {
        this.loops = loops;
    }

    public Boolean getContinueForever() {
        return this.continueForever;
    }

    public void setContinueForever(Boolean continueForever) {
        this.continueForever = continueForever;
    }

    public void setScheduler(Boolean scheduler) {
        this.scheduler = scheduler;
    }

    public Boolean getScheduler() {
        return this.scheduler;
    }

    public Boolean getDelayedStartup() {
        return this.delayedStartup;
    }

    public void setDelayedStartup(Boolean delayedStartup) {
        this.delayedStartup = delayedStartup;
    }

    public String getDuration() {
        return this.duration;
    }

    public void setDuration(String duration) {
        this.duration = duration;
    }

    private static final class ThreadGroupWrapperBuilderImpl
    extends ThreadGroupWrapperBuilder<ThreadGroupWrapper, ThreadGroupWrapperBuilderImpl> {
        private ThreadGroupWrapperBuilderImpl() {
        }

        @Override
        protected ThreadGroupWrapperBuilderImpl self() {
            return this;
        }

        @Override
        public ThreadGroupWrapper build() {
            return new ThreadGroupWrapper(this);
        }
    }

    public static abstract class ThreadGroupWrapperBuilder<C extends ThreadGroupWrapper, B extends ThreadGroupWrapperBuilder<C, B>>
    extends AbstractThreadGroupWrapper.AbstractThreadGroupWrapperBuilder<ThreadGroup, ThreadGroupGui, C, B> {
        private String delay;
        private boolean rampUp$set;
        private String rampUp$value;
        private boolean loops$set;
        private String loops$value;
        private boolean continueForever$set;
        private Boolean continueForever$value;
        private boolean scheduler$set;
        private Boolean scheduler$value;
        private boolean delayedStartup$set;
        private Boolean delayedStartup$value;
        private String duration;

        public B withRampUp(int rampUp) {
            return this.withRampUp(String.valueOf(rampUp));
        }

        public B withRampUp(Variable rampUp) {
            return this.withRampUp(String.valueOf(rampUp.getValue()));
        }

        public B withRampUp(String rampUp) {
            this.rampUp$value = rampUp;
            this.rampUp$set = true;
            return (B)this.self();
        }

        public B withDuration(int duration) {
            return this.withDuration(String.valueOf(duration));
        }

        public B withDuration(Variable duration) {
            return this.withDuration(String.valueOf(duration.getValue()));
        }

        public B withDuration(String duration) {
            this.duration = duration;
            return (B)this.self();
        }

        public B withDelay(int delay) {
            return this.withDelay(String.valueOf(delay));
        }

        public B withDelay(Variable delay) {
            return this.withDelay(String.valueOf(delay.getValue()));
        }

        public B withDelay(String delay) {
            this.delay = delay;
            return (B)this.self();
        }

        public B withLoops(int loops) {
            return this.withLoops(String.valueOf(loops));
        }

        public B withLoops(Variable loops) {
            return this.withLoops(String.valueOf(loops.getValue()));
        }

        public B withLoops(String loops) {
            this.loops$value = loops;
            this.loops$set = true;
            return (B)this.self();
        }

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            ThreadGroupWrapperBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(ThreadGroupWrapper instance, ThreadGroupWrapperBuilder<?, ?> b) {
            b.withDelay(instance.delay);
            b.withRampUp(instance.rampUp);
            b.withLoops(instance.loops);
            b.withContinueForever(instance.continueForever);
            b.withScheduler(instance.scheduler);
            b.withDelayedStartup(instance.delayedStartup);
            b.withDuration(instance.duration);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B withContinueForever(Boolean continueForever) {
            this.continueForever$value = continueForever;
            this.continueForever$set = true;
            return (B)this.self();
        }

        public B withScheduler(Boolean scheduler) {
            this.scheduler$value = scheduler;
            this.scheduler$set = true;
            return (B)this.self();
        }

        public B withDelayedStartup(Boolean delayedStartup) {
            this.delayedStartup$value = delayedStartup;
            this.delayedStartup$set = true;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "ThreadGroupWrapper.ThreadGroupWrapperBuilder(super=" + super.toString() + ", delay=" + this.delay + ", rampUp$value=" + this.rampUp$value + ", loops$value=" + this.loops$value + ", continueForever$value=" + this.continueForever$value + ", scheduler$value=" + this.scheduler$value + ", delayedStartup$value=" + this.delayedStartup$value + ", duration=" + this.duration + ")";
        }
    }
}

