/*
 * Decompiled with CFR 0.152.
 */
package org.anasoid.jmc.core.application;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Map;
import org.anasoid.jmc.core.config.JmcConfig;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.util.JMeterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JMeterHome {
    private static final Logger LOG = LoggerFactory.getLogger(JMeterHome.class);
    protected static final String SLASH = System.getProperty("file.separator");
    protected static final String JMETER_HOME = "JMETER_HOME";
    protected static final String JMETER_HOME_PROPERTY = "jmeter.home";
    private boolean initialized;
    private static JMeterHome instance;

    private JMeterHome() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JMeterHome getInstance() {
        Class<JMeterHome> clazz = JMeterHome.class;
        synchronized (JMeterHome.class) {
            if (instance == null) {
                instance = new JMeterHome();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    protected boolean init() {
        String jmeterHomePath = this.getJmeterHome();
        if (StringUtils.isBlank((CharSequence)jmeterHomePath)) {
            LOG.info("Jmeter is not configured by env variable {} or system variable {}", (Object)JMETER_HOME, (Object)JMETER_HOME_PROPERTY);
            jmeterHomePath = this.initLocalJmeter();
        }
        if (this.isValidJmeterHome(jmeterHomePath)) {
            LOG.info("Jmeter Home used from {}", (Object)jmeterHomePath);
            JMeterUtils.setJMeterHome((String)new File(jmeterHomePath).getPath());
            JMeterUtils.getProperties((String)new File(JMeterHome.getJmeterProperties(jmeterHomePath)).getPath());
            this.loadJmcPropertiesToJmeter();
            this.initialized = true;
        } else {
            this.initialized = false;
            LOG.error("Jmeter is not correctly configured,$JMETER_HOME is not correct or missing jmeter.properties, on : {} -> {}", (Object)jmeterHomePath, (Object)JMeterHome.getJmeterProperties(jmeterHomePath));
        }
        return this.initialized;
    }

    private String initLocalJmeter() {
        try {
            File homeDir = Files.createTempDirectory("jmc", new FileAttribute[0]).toFile();
            LOG.info("Creating temporary Jmeter home at : {}", (Object)homeDir.getPath());
            File binDir = new File(homeDir, "bin");
            try (FileSystem fs = FileSystems.newFileSystem(this.getClass().getResource("/bin/jmeter.properties").toURI(), Collections.emptyMap());){
                Path configBinDir = fs.getPath("/bin", new String[0]);
                for (Path p : Files.walk(configBinDir, new FileVisitOption[0])::iterator) {
                    String parent = p.getParent().toString();
                    if (!"/bin".startsWith(parent)) continue;
                    Path targetPath = binDir.toPath().resolve(configBinDir.relativize(p).toString());
                    Files.copy(p, targetPath, new CopyOption[0]);
                    targetPath.toFile().deleteOnExit();
                }
            }
            return homeDir.getPath();
        }
        catch (IOException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    protected boolean isValidJmeterHome(String jmeterHomePath) {
        File jmeterProperties;
        return jmeterHomePath != null && new File(jmeterHomePath).exists() && (jmeterProperties = new File(JMeterHome.getJmeterProperties(jmeterHomePath))).exists();
    }

    private static String getJmeterProperties(String jmeterHomePath) {
        return jmeterHomePath + SLASH + "bin" + SLASH + "jmeter.properties";
    }

    protected String getJmeterHome() {
        String jmeterHomePath = JmcConfig.getProperty(JMETER_HOME_PROPERTY);
        if (StringUtils.isBlank((CharSequence)jmeterHomePath) && (jmeterHomePath = System.getProperty(JMETER_HOME)) == null) {
            jmeterHomePath = System.getenv(JMETER_HOME);
        }
        return jmeterHomePath;
    }

    public void addProperties(Map<String, String> mapProperties) {
        mapProperties.forEach(JMeterUtils::setProperty);
    }

    private void loadJmcPropertiesToJmeter() {
        Map<String, String> jmcProperties = JmcConfig.getPropertyPrefix("jmeter");
        jmcProperties.remove(JMETER_HOME_PROPERTY);
        this.addProperties(jmcProperties);
    }

    protected boolean isInit() {
        return this.initialized;
    }
}

