/*
 * Decompiled with CFR 0.152.
 */
package org.anasoid.jmc.core.config;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.anasoid.jmc.core.config.JmcProperties;
import org.anasoid.jmc.core.config.JmcPropertiesManager;
import org.anasoid.jmc.core.xstream.exceptions.ConversionConfigException;
import org.apache.jmeter.save.SaveService;
import org.apache.jmeter.util.JMeterUtils;

public final class JmcConfig {
    private static final JmcPropertiesManager jmcPropertiesManager = new JmcPropertiesManager();
    private static final List<String> BOOLEAN_LIST = Arrays.asList("true", "false");

    private JmcConfig() {
    }

    public static String getDataRootFolder() {
        return JmcConfig.getJmcProperties().getProperty("jmc.data.root.folder");
    }

    public static String getScriptRootFolder() {
        return JmcConfig.getJmcProperties().getProperty("jmc.script.root.folder");
    }

    public static String getResultRootFolder() {
        return JmcConfig.getJmcProperties().getProperty("jmc.result.root.folder");
    }

    public static boolean isDataResource() {
        return "true".equalsIgnoreCase(JmcConfig.getJmcProperties().getProperty("jmc.data.resource"));
    }

    public static boolean isScriptResource() {
        return "true".equalsIgnoreCase(JmcConfig.getJmcProperties().getProperty("jmc.script.resource"));
    }

    public static String getVersion() {
        return SaveService.getVERSION();
    }

    public static String getJMeterVersion() {
        return JMeterUtils.getJMeterVersion();
    }

    public static String getPropertiesVersion() {
        return JmcConfig.getJmcProperties().getProperty("jmc.jmeter.properties.version");
    }

    public static String getProperty(String key) {
        return JmcConfig.getJmcProperties().getProperty(key);
    }

    public static String getProperty(String key, String defaultValue) {
        return JmcConfig.getJmcProperties().getProperty(key, defaultValue);
    }

    public static Boolean getBoolean(String key, Boolean defaultValue) {
        String value = JmcConfig.getJmcProperties().getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        String valueLower = value.trim().toLowerCase(Locale.ROOT);
        if (BOOLEAN_LIST.contains(valueLower)) {
            return Boolean.valueOf(valueLower);
        }
        throw new ConversionConfigException(MessageFormat.format("Can''t parse Boolean ({1}) from key : {0}", key, value));
    }

    public static Boolean getBoolean(String key) {
        return JmcConfig.getBoolean(key, null);
    }

    public static void setBoolean(String key, Boolean value) {
        JmcConfig.getJmcProperties().setProperty(key, value == null ? null : value.toString().toLowerCase(Locale.ROOT));
    }

    public static Integer getInteger(String key, Integer defaultValue) {
        String value = JmcConfig.getJmcProperties().getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            throw new ConversionConfigException(MessageFormat.format("Can''t parse integer ({1}) from key : {0}", key, value), e);
        }
    }

    public static Integer getInteger(String key) {
        return JmcConfig.getInteger(key, null);
    }

    public static void setInteger(String key, Integer value) {
        JmcConfig.getJmcProperties().setProperty(key, value == null ? null : value.toString());
    }

    public static void setProperty(String key, String value) {
        JmcConfig.getJmcProperties().setProperty(key, value);
    }

    public static Map<String, String> getPropertyPrefix(String prefix) {
        return JmcConfig.getJmcProperties().getPropertyPrefix(prefix);
    }

    private static JmcProperties getJmcProperties() {
        return jmcPropertiesManager.getCurrentJmcProperties();
    }

    public static void reset() {
        JmcPropertiesManager.reset();
    }

    public static AutoCloseable createLocalJmcConfig(Map<String, String> properties, String ... paths) {
        return new JmcPropertiesManager(properties, paths);
    }

    public static AutoCloseable createLocalJmcConfig(String ... paths) {
        return JmcConfig.createLocalJmcConfig(null, paths);
    }

    public static AutoCloseable createLocalJmcConfig(Map<String, String> properties, List<String> paths) {
        if (paths == null) {
            return JmcConfig.createLocalJmcConfig(properties, new String[0]);
        }
        return JmcConfig.createLocalJmcConfig(properties, paths.toArray(new String[0]));
    }
}

