/*
 * Decompiled with CFR 0.152.
 */
package org.anasoid.jmc.core.config;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.anasoid.jmc.core.xstream.exceptions.ConversionConfigException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JmcProperties {
    private static final Logger LOG = LoggerFactory.getLogger(JmcProperties.class);
    private static final String MAIN_CONFIG_FILE = "org/anasoid/jmc/core/config/jmc.properties";
    private static final String USER_CONFIG_FILE = "jmc-user.properties";
    private static final String SYSTEM_CONFIG_FILES_KEY = "jmc.configs";
    private static final String ENV_CONFIG_FILES_KEY = "JMC_CONFIGS";
    private static final String FILE_SEPARATOR = ";";
    private final Map<String, String> properties;

    protected JmcProperties() {
        this(null, new String[0]);
    }

    protected JmcProperties(JmcProperties jmcProperties, String ... paths) {
        this(jmcProperties, (Map<String, String>)null, paths);
    }

    protected JmcProperties(JmcProperties jmcProperties, Map<String, String> params, String ... paths) {
        this.properties = this.loadJmcProperties(jmcProperties, params, paths);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Properties getJmcProperties(String file, boolean quite) {
        Properties p = new Properties();
        try (InputStream is = Files.newInputStream(Paths.get(file, new String[0]), new OpenOption[0]);){
            p.load(is);
            LOG.info("Loading properties file : {}", (Object)file);
            return p;
        }
        catch (IOException e) {
            LOG.warn("File : {} Not found try loading resource", (Object)file);
            try (InputStream is2 = ClassLoader.getSystemResourceAsStream(file);){
                if (is2 == null) {
                    if (quite) {
                        LOG.info("Properties file : {} Not found", (Object)file);
                        Properties properties = p;
                        return properties;
                    }
                    throw new ConversionConfigException(MessageFormat.format("Config File not found : {0}", file));
                }
                p.load(is2);
                LOG.info("Loading resource file : {}", (Object)file);
                return p;
            }
            catch (IOException ex) {
                throw new ConversionConfigException(MessageFormat.format("ERROR : Config File not found : {0}", file));
            }
        }
    }

    private Map<String, String> loadJmcProperties(JmcProperties jmcProperties, Map<String, String> params, String ... paths) {
        LOG.info("Loading properties");
        ArrayList<Object> defaultFiles = new ArrayList<Object>();
        defaultFiles.add(MAIN_CONFIG_FILE);
        defaultFiles.add(USER_CONFIG_FILE);
        defaultFiles.add(System.getProperties().getProperty("user.home") + File.separator + USER_CONFIG_FILE);
        ArrayList<String> files = new ArrayList<String>();
        files.addAll(JmcProperties.getJmcFiles(System.getenv(ENV_CONFIG_FILES_KEY)));
        files.addAll(JmcProperties.getJmcFiles(System.getProperties().getProperty(SYSTEM_CONFIG_FILES_KEY)));
        Properties p = new Properties();
        if (jmcProperties != null) {
            jmcProperties.properties.entrySet().forEach(c -> p.put(c.getKey(), c.getValue()));
        }
        defaultFiles.forEach(c -> p.putAll((Map<?, ?>)JmcProperties.getJmcProperties(c, true)));
        files.forEach(c -> p.putAll((Map<?, ?>)JmcProperties.getJmcProperties(c, false)));
        p.putAll((Map<?, ?>)System.getProperties());
        if (paths != null) {
            Arrays.stream(paths).forEach(c -> p.putAll((Map<?, ?>)JmcProperties.getJmcProperties(c, false)));
        }
        if (params != null) {
            params.entrySet().stream().forEach(c -> p.put(c.getKey(), c.getValue()));
        }
        return new HashMap<Object, Object>(p);
    }

    private static List<String> getJmcFiles(String files) {
        ArrayList<String> results = new ArrayList<String>();
        if (files == null) {
            return results;
        }
        results.addAll(Arrays.asList(files.split(FILE_SEPARATOR)));
        return results;
    }

    protected String getProperty(String key) {
        return this.properties.get(key);
    }

    protected String getProperty(String key, String defaultValue) {
        String value = this.properties.get(key);
        return value != null ? value : defaultValue;
    }

    protected void setProperty(String key, String value) {
        this.properties.put(key, value);
    }

    protected Map<String, String> getPropertyPrefix(String prefix) {
        HashMap<String, String> result = new HashMap<String, String>();
        String fullPrefix = prefix + ".";
        this.properties.entrySet().stream().filter(c -> ((String)c.getKey()).startsWith(fullPrefix)).forEach(c -> result.put((String)c.getKey(), (String)c.getValue()));
        return result;
    }
}

