/*
 * Decompiled with CFR 0.152.
 */
package org.anasoid.jmc.core.wrapper.jmc.functions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.anasoid.jmc.core.util.FunctionsUtils;
import org.anasoid.jmc.core.wrapper.jmc.Variable;

public final class JmeterFunctions {
    public static final String ALPHA = "abcdefghijklmnopqrstuvwxyz";
    public static final String ALPHA_UPPER = "abcdefghijklmnopqrstuvwxyz".toUpperCase(Locale.ROOT);
    public static final String NUMERIC = "0123456789";
    public static final String ALPHA_NUMERIC = "abcdefghijklmnopqrstuvwxyz0123456789";

    private JmeterFunctions() {
    }

    public static String changeCase(@NonNull String input, ChangeCaseMode mode) {
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        return FunctionsUtils.function("changeCase", new Object[]{input, mode});
    }

    public static String csvRead(@NonNull String file, @NonNull String columnNum) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        if (columnNum == null) {
            throw new NullPointerException("columnNum is marked non-null but is null");
        }
        return FunctionsUtils.function("CSVRead", file, columnNum);
    }

    public static String csvRead(@NonNull String file, @NonNull Integer columnNum) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        if (columnNum == null) {
            throw new NullPointerException("columnNum is marked non-null but is null");
        }
        return FunctionsUtils.function("CSVRead", file, columnNum);
    }

    public static String digest(@NonNull String input, @NonNull DigestAlgorithm algorithm, String salt, Boolean upper, Variable variable) {
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        if (algorithm == null) {
            throw new NullPointerException("algorithm is marked non-null but is null");
        }
        return FunctionsUtils.function("digest", new Object[]{algorithm, input, salt, upper, variable});
    }

    public static String digest(@NonNull String input, @NonNull DigestAlgorithm algorithm, String salt) {
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        if (algorithm == null) {
            throw new NullPointerException("algorithm is marked non-null but is null");
        }
        return JmeterFunctions.digest(input, algorithm, salt, null, null);
    }

    public static String digest(@NonNull String input, @NonNull DigestAlgorithm algorithm, Boolean upper) {
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        if (algorithm == null) {
            throw new NullPointerException("algorithm is marked non-null but is null");
        }
        return JmeterFunctions.digest(input, algorithm, null, upper, null);
    }

    public static String digest(@NonNull String input, @NonNull DigestAlgorithm algorithm, Variable variable) {
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        if (algorithm == null) {
            throw new NullPointerException("algorithm is marked non-null but is null");
        }
        return JmeterFunctions.digest(input, algorithm, null, null, variable);
    }

    public static String digest(@NonNull String input, @NonNull DigestAlgorithm algorithm, String salt, Variable variable) {
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        if (algorithm == null) {
            throw new NullPointerException("algorithm is marked non-null but is null");
        }
        return JmeterFunctions.digest(input, algorithm, salt, null, variable);
    }

    public static String dateTimeConvert(@NonNull String source, String sourceDateFormat, String targetDateFormat, Variable variableName) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        return FunctionsUtils.function("dateTimeConvert", source, sourceDateFormat, targetDateFormat, variableName);
    }

    public static String dateTimeConvert(@NonNull String source, String sourceDateFormat, String targetDateFormat) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        return JmeterFunctions.dateTimeConvert(source, sourceDateFormat, targetDateFormat, null);
    }

    public static String dateTimeConvert(@NonNull String source, String targetDateFormat) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        return JmeterFunctions.dateTimeConvert(source, targetDateFormat, (Variable)null);
    }

    public static String dateTimeConvert(@NonNull String source, String targetDateFormat, Variable variableName) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        return JmeterFunctions.dateTimeConvert(source, null, targetDateFormat, variableName);
    }

    public static String counter(@NonNull Boolean perThread, Variable variableName) {
        if (perThread == null) {
            throw new NullPointerException("perThread is marked non-null but is null");
        }
        return FunctionsUtils.function("counter", perThread.toString().toUpperCase(Locale.ROOT), variableName);
    }

    public static String counter(@NonNull Boolean perThread) {
        if (perThread == null) {
            throw new NullPointerException("perThread is marked non-null but is null");
        }
        return JmeterFunctions.counter(perThread, null);
    }

    public static String chars(String ... input) {
        return FunctionsUtils.function("char", input);
    }

    public static String escapeHtml(String input) {
        return FunctionsUtils.function("escapeHtml", input);
    }

    public static String escapeOroRegexpChars(String input) {
        return JmeterFunctions.escapeOroRegexpChars(input, null);
    }

    public static String escapeOroRegexpChars(String input, Variable variableName) {
        return FunctionsUtils.function("escapeOroRegexpChars", input, variableName);
    }

    public static String escapeXml(String input) {
        return FunctionsUtils.function("escapeXml", input);
    }

    public static String eval(@NonNull String val) {
        if (val == null) {
            throw new NullPointerException("val is marked non-null but is null");
        }
        return FunctionsUtils.function("eval", val);
    }

    public static String evalVar(@NonNull Variable variable) {
        if (variable == null) {
            throw new NullPointerException("variable is marked non-null but is null");
        }
        return FunctionsUtils.function("evalVar", variable.getName());
    }

    public static String fileToString(@NonNull String file, String encoding, Variable variable) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        return FunctionsUtils.function("FileToString", file, encoding, variable);
    }

    public static String fileToString(@NonNull String file, String encoding) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        return JmeterFunctions.fileToString(file, encoding, null);
    }

    public static String fileToString(@NonNull String file, Variable variable) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        return JmeterFunctions.fileToString(file, null, variable);
    }

    public static String groovy(@NonNull String expression, Variable variableName) {
        if (expression == null) {
            throw new NullPointerException("expression is marked non-null but is null");
        }
        return FunctionsUtils.function("groovy", expression, variableName);
    }

    public static String groovy(@NonNull String expression) {
        if (expression == null) {
            throw new NullPointerException("expression is marked non-null but is null");
        }
        return JmeterFunctions.groovy(expression, null);
    }

    public static String intSum(Variable variable, String ... values) {
        ArrayList<String> params = new ArrayList<String>(Arrays.asList(values));
        params.add((String)((Object)variable));
        return FunctionsUtils.function("intSum", params.toArray());
    }

    public static String intSum(String ... values) {
        return JmeterFunctions.intSum(null, values);
    }

    public static String intSum(Variable variable, Integer ... values) {
        String[] itemsArray = new String[values.length];
        return JmeterFunctions.intSum(variable, Arrays.stream(values).map(Object::toString).collect(Collectors.toList()).toArray(itemsArray));
    }

    public static String intSum(Integer ... values) {
        return JmeterFunctions.intSum(null, values);
    }

    public static String isPropDefined(@NonNull String propertyName) {
        if (propertyName == null) {
            throw new NullPointerException("propertyName is marked non-null but is null");
        }
        return FunctionsUtils.function("isPropDefined", propertyName);
    }

    public static String isVarDefined(@NonNull Variable variable) {
        if (variable == null) {
            throw new NullPointerException("variable is marked non-null but is null");
        }
        return FunctionsUtils.function("isVarDefined", variable.getName());
    }

    public static String javaScript(@NonNull String expression, Variable variableName) {
        if (expression == null) {
            throw new NullPointerException("expression is marked non-null but is null");
        }
        return FunctionsUtils.function("javaScript", expression, variableName);
    }

    public static String javaScript(@NonNull String expression) {
        if (expression == null) {
            throw new NullPointerException("expression is marked non-null but is null");
        }
        return JmeterFunctions.javaScript(expression, null);
    }

    public static String jexl3(@NonNull String expression, Variable variableName) {
        if (expression == null) {
            throw new NullPointerException("expression is marked non-null but is null");
        }
        return FunctionsUtils.function("jexl3", expression, variableName);
    }

    public static String jexl3(@NonNull String expression) {
        if (expression == null) {
            throw new NullPointerException("expression is marked non-null but is null");
        }
        return JmeterFunctions.jexl3(expression, null);
    }

    public static String log(String input, LogLevel logLevel, String throwable, String comment) {
        return FunctionsUtils.function("log", new Object[]{input, logLevel, throwable, comment});
    }

    public static String log(String input, LogLevel logLevel, String comment) {
        return JmeterFunctions.log(input, logLevel, null, comment);
    }

    public static String log(String input, LogLevel logLevel) {
        return JmeterFunctions.log(input, logLevel, null);
    }

    public static String log(String input) {
        return JmeterFunctions.log(input, null);
    }

    public static String logn(String input, LogLevel logLevel, String throwable) {
        return FunctionsUtils.function("logn", new Object[]{input, logLevel, throwable});
    }

    public static String logn(String input, LogLevel logLevel) {
        return JmeterFunctions.logn(input, logLevel, null);
    }

    public static String logn(String input) {
        return JmeterFunctions.logn(input, null);
    }

    public static String longSum(Variable variable, String ... values) {
        ArrayList<String> params = new ArrayList<String>(Arrays.asList(values));
        params.add((String)((Object)variable));
        return FunctionsUtils.function("longSum", params.toArray());
    }

    public static String longSum(String ... values) {
        return JmeterFunctions.longSum(null, values);
    }

    public static String longSum(Variable variable, Long ... values) {
        String[] itemsArray = new String[values.length];
        return JmeterFunctions.longSum(variable, Arrays.stream(values).map(Object::toString).collect(Collectors.toList()).toArray(itemsArray));
    }

    public static String longSum(Long ... values) {
        return JmeterFunctions.longSum(null, values);
    }

    public static String machineIP() {
        return JmeterFunctions.machineIP(null);
    }

    public static String machineIP(Variable variable) {
        return FunctionsUtils.function("machineIP", variable);
    }

    public static String machineName() {
        return JmeterFunctions.machineName(null);
    }

    public static String machineName(Variable variable) {
        return FunctionsUtils.function("machineName", variable);
    }

    public static String property(@NonNull String propertyName, Variable variableName, String defaultValue) {
        if (propertyName == null) {
            throw new NullPointerException("propertyName is marked non-null but is null");
        }
        if (variableName == null) {
            return FunctionsUtils.function("P", propertyName, defaultValue);
        }
        return FunctionsUtils.function("property", propertyName, variableName, defaultValue);
    }

    public static String property(@NonNull String propertyName, String defaultValue) {
        if (propertyName == null) {
            throw new NullPointerException("propertyName is marked non-null but is null");
        }
        return JmeterFunctions.property(propertyName, null, defaultValue);
    }

    public static String property(@NonNull String propertyName) {
        if (propertyName == null) {
            throw new NullPointerException("propertyName is marked non-null but is null");
        }
        return JmeterFunctions.property(propertyName, null, null);
    }

    public static String random(String min, String max, Variable variableName) {
        return FunctionsUtils.function("Random", min, max, variableName);
    }

    public static String random(String min, String max) {
        return JmeterFunctions.random(min, max, null);
    }

    public static String random(int min, int max, Variable variableName) {
        return JmeterFunctions.random(String.valueOf(min), String.valueOf(max), variableName);
    }

    public static String random(int min, int max) {
        return JmeterFunctions.random(min, max, null);
    }

    public static String randomAlpha(String length, Variable variableName) {
        return JmeterFunctions.randomString(length, ALPHA, variableName);
    }

    public static String randomAlpha(int length, Variable variableName) {
        return JmeterFunctions.randomAlpha(String.valueOf(length), variableName);
    }

    public static String randomAlpha(int length) {
        return JmeterFunctions.randomAlpha(String.valueOf(length), null);
    }

    public static String randomAlphaNumeric(String length, Variable variableName) {
        return JmeterFunctions.randomString(length, ALPHA_NUMERIC, variableName);
    }

    public static String randomAlphaNumeric(int length, Variable variableName) {
        return JmeterFunctions.randomAlphaNumeric(String.valueOf(length), variableName);
    }

    public static String randomAlphaNumeric(int length) {
        return JmeterFunctions.randomAlphaNumeric(String.valueOf(length), null);
    }

    public static String randomDate(String format, String startDate, @NonNull String endDate, String locale, Variable variableName) {
        if (endDate == null) {
            throw new NullPointerException("endDate is marked non-null but is null");
        }
        return FunctionsUtils.function("RandomDate", format, startDate, endDate, locale, variableName);
    }

    public static String randomDate(String format, String startDate, @NonNull String endDate, String locale) {
        if (endDate == null) {
            throw new NullPointerException("endDate is marked non-null but is null");
        }
        return JmeterFunctions.randomDate(format, startDate, endDate, locale, null);
    }

    public static String randomDate(String format, String startDate, @NonNull String endDate) {
        if (endDate == null) {
            throw new NullPointerException("endDate is marked non-null but is null");
        }
        return JmeterFunctions.randomDate(format, startDate, endDate, null);
    }

    public static String randomFromMultipleVars(@NonNull Variable variable, Variable ... sourceVariables) {
        if (variable == null) {
            throw new NullPointerException("variable is marked non-null but is null");
        }
        if (sourceVariables == null) {
            throw new NullPointerException("sourceVariables is marked non-null but is null");
        }
        String values = String.join((CharSequence)"|", Arrays.asList(sourceVariables).stream().map(Variable::getName).collect(Collectors.toList()));
        return FunctionsUtils.function("RandomFromMultipleVars", values, variable);
    }

    public static String randomString(String length, String chars, Variable variableName) {
        return FunctionsUtils.function("RandomString", length, chars, variableName);
    }

    public static String randomString(String length, String chars) {
        return JmeterFunctions.randomString(length, chars, null);
    }

    public static String randomString(int length, String chars, Variable variableName) {
        return JmeterFunctions.randomString(String.valueOf(length), chars, variableName);
    }

    public static String randomString(int length, String chars) {
        return JmeterFunctions.randomString(length, chars, null);
    }

    public static String regexFunction(@NonNull String regex, String template, String match) {
        if (regex == null) {
            throw new NullPointerException("regex is marked non-null but is null");
        }
        return FunctionsUtils.function("regexFunction", regex, template, match);
    }

    public static String regexFunction(@NonNull String regex, String template, int match) {
        if (regex == null) {
            throw new NullPointerException("regex is marked non-null but is null");
        }
        return JmeterFunctions.regexFunction(regex, template, String.valueOf(match));
    }

    public static String samplerName() {
        return JmeterFunctions.samplerName(null);
    }

    public static String samplerName(Variable variable) {
        return FunctionsUtils.function("samplerName", variable);
    }

    public static String setProperty(@NonNull String propertyName, String propertyValue, Boolean returnOrigin) {
        if (propertyName == null) {
            throw new NullPointerException("propertyName is marked non-null but is null");
        }
        return FunctionsUtils.function("setProperty", propertyName, propertyValue, returnOrigin);
    }

    public static String setProperty(@NonNull String propertyName, String propertyValue) {
        if (propertyName == null) {
            throw new NullPointerException("propertyName is marked non-null but is null");
        }
        return JmeterFunctions.setProperty(propertyName, propertyValue, null);
    }

    public static String split(@NonNull String input, @NonNull String variableName, String separator) {
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        if (variableName == null) {
            throw new NullPointerException("variableName is marked non-null but is null");
        }
        if (separator != null) {
            separator = separator.replace(",", "\\,");
        }
        return FunctionsUtils.function("split", input, variableName, separator);
    }

    public static String split(@NonNull String input, @NonNull String variableName) {
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        if (variableName == null) {
            throw new NullPointerException("variableName is marked non-null but is null");
        }
        return JmeterFunctions.split(input, variableName, null);
    }

    public static String stringFromFile(@NonNull String file, Variable variable, String startSequence, String endSequence) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        return FunctionsUtils.function("StringFromFile", file, variable, startSequence, endSequence);
    }

    public static String stringFromFile(@NonNull String file, Variable variable, Integer startSequence, Integer endSequence) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        return JmeterFunctions.stringFromFile(file, variable, String.valueOf(startSequence), String.valueOf(endSequence));
    }

    public static String stringFromFile(@NonNull String file, Variable variable) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        return JmeterFunctions.stringFromFile(file, variable, (String)null, (String)null);
    }

    public static String stringFromFile(@NonNull String file) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        return JmeterFunctions.stringFromFile(file, null, (String)null, (String)null);
    }

    public static String stringToFile(@NonNull String file, @NonNull String input, Boolean append, String encoding) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        return FunctionsUtils.function("StringToFile", file, input, append == null ? "" : append.toString().toLowerCase(Locale.ROOT), encoding);
    }

    public static String stringToFile(@NonNull String file, @NonNull String input, Boolean append) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        return JmeterFunctions.stringToFile(file, input, append, null);
    }

    public static String stringToFile(@NonNull String file, @NonNull String input) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        return JmeterFunctions.stringToFile(file, input, null, null);
    }

    public static String testPlanName() {
        return FunctionsUtils.function("TestPlanName", new Object[0]);
    }

    public static String threadGroupName() {
        return FunctionsUtils.function("threadGroupName", new Object[0]);
    }

    public static String threadNum() {
        return FunctionsUtils.function("threadNum", new Object[0]);
    }

    public static String time(String format, Variable variableName) {
        return FunctionsUtils.function("time", format, variableName);
    }

    public static String time(String format) {
        return JmeterFunctions.time(format, null);
    }

    public static String time() {
        return JmeterFunctions.time(null, null);
    }

    public static String timeShift(String format, String dateToShift, String valueToShift, String locale, Variable variableName) {
        return FunctionsUtils.function("timeShift", format, dateToShift, valueToShift, locale, variableName);
    }

    public static String timeShift(String format, String dateToShift, String valueToShift, String locale) {
        return JmeterFunctions.timeShift(format, dateToShift, valueToShift, locale, null);
    }

    public static String urlDecode(String url) {
        return FunctionsUtils.function("urldecode", url);
    }

    public static String unescape(String input) {
        return FunctionsUtils.function("unescape", input);
    }

    public static String unescapeHtml(String input) {
        return FunctionsUtils.function("unescapeHtml", input);
    }

    public static String urlEncode(String url) {
        return FunctionsUtils.function("urlencode", url);
    }

    public static String uuid() {
        return FunctionsUtils.function("UUID", new Object[0]);
    }

    public static String variableValue(String varName, String defaultValue) {
        return FunctionsUtils.function("V", varName, defaultValue);
    }

    public static String variableValue(String varName) {
        return JmeterFunctions.variableValue(varName, null);
    }

    public static String xpath(@NonNull String file, @NonNull String xpath) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        if (xpath == null) {
            throw new NullPointerException("xpath is marked non-null but is null");
        }
        return FunctionsUtils.function("XPath", file, xpath);
    }

    public static enum LogLevel {
        OUT,
        ERR,
        DEBUG,
        INFO,
        WARN,
        ERROR;

    }

    public static enum DigestAlgorithm {
        MD2,
        MD5,
        SHA1,
        SHA224,
        SHA256,
        SHA384,
        SHA512;

    }

    public static enum ChangeCaseMode {
        UPPER,
        LOWER,
        CAPITALIZE;

    }
}

