/*
 * Copyright 2020-2021 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License")
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * @author : anas
 * Date :   27-Feb-2021
 */

package org.anasoid.jmc.core.wrapper.jmeter.config;

import lombok.experimental.SuperBuilder;
import org.anasoid.jmc.core.wrapper.jmeter.gui.JMeterGUIWrapper;
import org.anasoid.jmc.core.wrapper.jmeter.testelement.basic.AbstractBasicChildTestElementWrapper;
import org.apache.jmeter.config.ConfigTestElement;
import org.apache.jmeter.gui.JMeterGUIComponent;
import org.apache.jmeter.testelement.AbstractTestElement;

/**
 * Wrapper for ConfigTestElement.
 *
 * @see ConfigTestElement
 */
@SuperBuilder(setterPrefix = "with", toBuilder = true)
public abstract class ConfigTestElementWrapper<
        T extends AbstractTestElement, G extends JMeterGUIComponent>
    extends AbstractBasicChildTestElementWrapper<T>
    implements JMeterGUIWrapper<G>, ConfigElementWrapper<T> {}
