/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.annotation.mark;

import java.util.Calendar;
import java.util.Date;
import lombok.Generated;
import org.anchoranalysis.annotation.mark.AnnotationWithMarks;
import org.anchoranalysis.annotation.mark.DualMarks;
import org.anchoranalysis.core.exception.CheckedUnsupportedOperationException;
import org.anchoranalysis.mpp.bean.regionmap.RegionMapSingleton;
import org.anchoranalysis.mpp.bean.regionmap.RegionMembershipWithFlags;
import org.anchoranalysis.mpp.mark.MarkCollection;
import org.anchoranalysis.spatial.scale.ScaleFactor;

public class DualMarksAnnotation<T>
implements AnnotationWithMarks {
    private boolean accepted = false;
    private T rejectionReason;
    private MarkCollection marks;
    private MarkCollection marksReject;
    private Date timeAnnotationLastUpdated;
    private boolean finished = false;
    private int regionID = 0;

    public void assignAccepted(DualMarks dualMark) {
        this.finished = true;
        this.accepted = true;
        this.assign(dualMark);
    }

    public void assignPaused(DualMarks dualMark) {
        this.finished = false;
        this.accepted = true;
        this.assign(dualMark);
    }

    public void assignRejected(DualMarks dualMark, T reason) {
        this.accepted = false;
        this.finished = true;
        this.assign(dualMark);
        this.rejectionReason = reason;
    }

    private void recordCurrentTime() {
        this.timeAnnotationLastUpdated = Calendar.getInstance().getTime();
    }

    @Override
    public MarkCollection marks() {
        return this.marks;
    }

    public void scaleXY(ScaleFactor scaleFactor) throws CheckedUnsupportedOperationException {
        this.marks.scaleXY(scaleFactor);
        this.marksReject.scaleXY(scaleFactor);
    }

    @Override
    public RegionMembershipWithFlags region() {
        return RegionMapSingleton.instance().membershipWithFlagsForIndex(this.regionID);
    }

    private void assign(DualMarks dualMark) {
        this.marks = dualMark.accepted();
        this.marksReject = dualMark.rejected();
        this.recordCurrentTime();
    }

    @Generated
    public boolean isAccepted() {
        return this.accepted;
    }

    @Generated
    public T getRejectionReason() {
        return this.rejectionReason;
    }

    @Generated
    public MarkCollection getMarksReject() {
        return this.marksReject;
    }

    @Generated
    public Date getTimeAnnotationLastUpdated() {
        return this.timeAnnotationLastUpdated;
    }

    @Generated
    public boolean isFinished() {
        return this.finished;
    }
}

