/*-
 * #%L
 * anchor-bean
 * %%
 * Copyright (C) 2010 - 2020 Owen Feehan, ETH Zurich, University of Zurich, Hoffmann-La Roche
 * %%
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 * #L%
 */

package org.anchoranalysis.bean.permute.assign;

import org.anchoranalysis.bean.AnchorBean;

/**
 * Imposes a permutation on some property of a bean.
 *
 * <p>This can be an immediate property of a bean, or property of some nested-bean. e.g.
 *
 * <ul>
 *   <li>{@code Bean.x} (immediate property) {@code Bean.child1.child2.child3.x} (nested).
 *   <li>All intermediate children must be beans.
 * </ul>
 *
 * @author Owen Feehan
 */
public interface PermutationAssigner {

    /**
     * Assigns {@code value} to one or more properties in {@code bean}.
     *
     * @param bean the bean whose property or properties will be assigned.
     * @param value the value which will be assigned.
     * @throws AssignPermutationException if the assignment cannot successfully complete due to an
     *     incorrect bean-type or illegal access.
     */
    void assignValue(AnchorBean<?> bean, Object value) throws AssignPermutationException;
}
