/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.bean;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.anchoranalysis.bean.NamedBean;
import org.anchoranalysis.bean.exception.BeanMisconfiguredException;

public class BeanInstanceMap {
    private Map<Class<?>, Object> map = new HashMap();

    public boolean containsFamily(Class<?> familyType) {
        return this.map.containsKey(familyType);
    }

    public <T> Optional<T> getInstanceFor(Class<? extends T> familyType) {
        Object instance = this.map.get(familyType);
        if (instance != null) {
            return Optional.of(instance);
        }
        return Optional.empty();
    }

    public <T> T putInstanceFor(Class<? extends T> familyType, T instance) {
        this.map.put(familyType, instance);
        return instance;
    }

    public <T> void removeInstanceFor(Class<? extends T> familyType) {
        this.map.remove(familyType);
    }

    public void addFrom(BeanInstanceMap other) {
        for (Map.Entry<Class<?>, Object> entry : other.map.entrySet()) {
            this.map.put(entry.getKey(), entry.getValue());
        }
    }

    public void addFrom(List<NamedBean<?>> listNamedInstances) throws BeanMisconfiguredException {
        try {
            for (NamedBean<?> namedBean : listNamedInstances) {
                this.map.put(Class.forName(namedBean.getName()), namedBean.getValue());
            }
        }
        catch (ClassNotFoundException e) {
            throw new BeanMisconfiguredException(String.format("Cannot find class %s that is referred to in bean XML", e.getClass().toString()), e);
        }
    }
}

