/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.bean;

import java.lang.reflect.Field;
import java.util.Optional;
import org.anchoranalysis.bean.AnchorBean;
import org.anchoranalysis.bean.annotation.OptionalBean;
import org.anchoranalysis.bean.exception.BeanMisconfiguredException;

public class FieldAccessor {
    public static Optional<Object> fieldFromBean(AnchorBean<?> bean, Field field) throws IllegalAccessException, BeanMisconfiguredException {
        Object value = field.get(bean);
        if (value == null) {
            if (FieldAccessor.isFieldAnnotatedAsOptional(field)) {
                return Optional.empty();
            }
            FieldAccessor.throwMissingPropertyException(field.getName(), bean.getBeanName());
        }
        return Optional.of(value);
    }

    public static boolean isFieldAnnotatedAsOptional(Field field) {
        return field.isAnnotationPresent(OptionalBean.class);
    }

    private static void throwMissingPropertyException(String fieldName, String className) throws BeanMisconfiguredException {
        throw new BeanMisconfiguredException(String.format("Property %s of class %s must be non-null", fieldName, className));
    }

    private FieldAccessor() {
    }
}

