/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.bean;

import java.lang.reflect.Field;
import java.util.List;
import java.util.Optional;
import org.anchoranalysis.bean.AnchorBean;
import org.anchoranalysis.bean.FieldAccessor;
import org.anchoranalysis.bean.HelperReflection;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.exception.BeanMisconfiguredException;
import org.anchoranalysis.bean.exception.BeanStrangeException;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.functional.FunctionalList;

class HelperBeanFields {
    public static String describeChildBeans(AnchorBean<?> bean) {
        try {
            List descriptions = FunctionalList.mapToListOptional(bean.fields(), OperationFailedException.class, field -> HelperBeanFields.maybeDescribeChildBean(bean, field));
            return String.join((CharSequence)", ", descriptions);
        }
        catch (OperationFailedException e) {
            throw new BeanStrangeException("Failed to describe child beans", e);
        }
    }

    public static List<Field> createListBeanPropertyFields(Class<?> clss) {
        List<Field> allFields = HelperReflection.findAllFields(clss);
        return FunctionalList.filterAndMapToList(allFields, field -> field.isAnnotationPresent(BeanField.class), field -> {
            field.setAccessible(true);
            return field;
        });
    }

    private static String describeBean(AnchorBean<?> bean) {
        StringBuilder builder = new StringBuilder();
        builder.append(bean.getBeanName());
        builder.append("(");
        builder.append(HelperBeanFields.describeChildBeans(bean));
        builder.append(")");
        return builder.toString();
    }

    private static Optional<String> maybeDescribeChildBean(AnchorBean<?> bean, Field field) throws OperationFailedException {
        try {
            FieldAccessor.fieldFromBean(bean, field);
            return Optional.of(String.format("%s=%s", field.getName(), HelperBeanFields.describeField(field, bean)));
        }
        catch (IllegalAccessException | IllegalArgumentException | BeanMisconfiguredException | OperationFailedException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    private static String describeField(Field field, AnchorBean<?> bean) throws OperationFailedException {
        try {
            Object value = field.get(bean);
            if (value instanceof AnchorBean) {
                return HelperBeanFields.describeBean((AnchorBean)value);
            }
            if (value instanceof List) {
                return "list";
            }
            if (value instanceof String) {
                return "'" + (String)value + "'";
            }
            if (value instanceof Integer) {
                return Integer.toString((Integer)value);
            }
            if (value instanceof Double) {
                return Double.toString((Double)value);
            }
            if (value instanceof Float) {
                return Float.toString(((Float)value).floatValue());
            }
            if (value instanceof Byte) {
                return Byte.toString((Byte)value);
            }
            if (value instanceof Short) {
                return Short.toString((Short)value);
            }
            if (value instanceof Long) {
                return Long.toString((Long)value);
            }
            if (value instanceof Boolean) {
                return (Boolean)value != false ? "true" : "false";
            }
            throw new OperationFailedException("Unknown bean type");
        }
        catch (IllegalAccessException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    private HelperBeanFields() {
    }
}

