/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.bean;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.anchoranalysis.bean.AnchorBean;
import org.anchoranalysis.bean.BeanInstanceMap;
import org.anchoranalysis.bean.FieldAccessor;
import org.anchoranalysis.bean.annotation.AllowEmpty;
import org.anchoranalysis.bean.annotation.DefaultInstance;
import org.anchoranalysis.bean.annotation.NonEmpty;
import org.anchoranalysis.bean.annotation.NonNegative;
import org.anchoranalysis.bean.annotation.Positive;
import org.anchoranalysis.bean.exception.BeanMisconfiguredException;

class HelperCheckMisconfigured {
    private final BeanInstanceMap defaultInstances;

    HelperCheckMisconfigured(BeanInstanceMap defaultInstances) {
        this.defaultInstances = defaultInstances;
    }

    public void checkMisconfiguredWithFields(AnchorBean<?> bean, List<Field> listFields) throws BeanMisconfiguredException {
        String beanName = bean.getClass().getName();
        try {
            for (Field field : listFields) {
                Object value = field.get(bean);
                if (value == null && field.isAnnotationPresent(DefaultInstance.class)) {
                    value = this.findDefaultInstance(field.getType());
                    field.set(bean, value);
                }
                if (value == null && !FieldAccessor.isFieldAnnotatedAsOptional(field)) {
                    throw new BeanMisconfiguredException(String.format("Property '%s' of object '%s' must be non-null", field.getName(), beanName));
                }
                if (value == null) continue;
                this.checkProperty(field, value, beanName);
            }
        }
        catch (IllegalAccessException e) {
            throw new BeanMisconfiguredException("An exception occurred accessing a property", e);
        }
    }

    private Object findDefaultInstance(Class<?> classType) throws BeanMisconfiguredException {
        Optional<?> object = this.defaultInstances.getInstanceFor(classType);
        if (!object.isPresent()) {
            throw new BeanMisconfiguredException(String.format("No default property can be found for class '%s'", classType.getName()));
        }
        return object.get();
    }

    private void checkProperty(Field field, Object fieldValue, String beanName) throws BeanMisconfiguredException {
        if (fieldValue instanceof AnchorBean) {
            AnchorBean valueCast = (AnchorBean)fieldValue;
            valueCast.checkMisconfigured(this.defaultInstances);
        } else if (fieldValue instanceof Collection) {
            Collection valueCast = (Collection)fieldValue;
            this.checkCollection(valueCast, field, beanName);
        } else if (fieldValue instanceof String) {
            String valueCast = (String)fieldValue;
            HelperCheckMisconfigured.checkString(valueCast, field, beanName);
        } else {
            this.checkPropertyPrimitiveTypes(field, fieldValue, beanName);
        }
    }

    private void checkPropertyPrimitiveTypes(Field field, Object fieldValue, String beanName) throws BeanMisconfiguredException {
        if (fieldValue instanceof Integer) {
            Integer valueCast = (Integer)fieldValue;
            HelperCheckMisconfigured.checkInteger(valueCast, field, beanName);
        } else if (fieldValue instanceof Double) {
            Double valueCast = (Double)fieldValue;
            HelperCheckMisconfigured.checkDouble(valueCast, field, beanName);
        } else if (fieldValue instanceof Float) {
            Float valueCast = (Float)fieldValue;
            HelperCheckMisconfigured.checkFloat(valueCast, field, beanName);
        } else if (fieldValue instanceof Short) {
            Short valueCast = (Short)fieldValue;
            HelperCheckMisconfigured.checkShort(valueCast, field, beanName);
        } else if (fieldValue instanceof Long) {
            Long valueCast = (Long)fieldValue;
            HelperCheckMisconfigured.checkLong(valueCast, field, beanName);
        }
    }

    private void checkCollection(Collection<AnchorBean<?>> list, Field field, String beanName) throws BeanMisconfiguredException {
        if (field.isAnnotationPresent(NonEmpty.class) && list.isEmpty()) {
            throw new BeanMisconfiguredException(String.format("at least one item in property '%s' of '%s' must be present", field.getName(), beanName));
        }
        for (AnchorBean<?> item : list) {
            if (item == null) continue;
            item.checkMisconfigured(this.defaultInstances);
        }
    }

    private static void checkString(String fieldValue, Field field, String beanName) throws BeanMisconfiguredException {
        if (!field.isAnnotationPresent(AllowEmpty.class) && (fieldValue == null || fieldValue.isEmpty())) {
            throw new BeanMisconfiguredException(String.format("Property '%s' of '%s' must be non-empty", field.getName(), beanName));
        }
    }

    private static void generateNonNegativeException(String fieldName, String beanName) throws BeanMisconfiguredException {
        throw new BeanMisconfiguredException(String.format("Property '%s' of '%s' must be >= 0", fieldName, beanName));
    }

    private static void generatePositiveException(String fieldName, String beanName) throws BeanMisconfiguredException {
        throw new BeanMisconfiguredException(String.format("Property '%s' of '%s' must be > 0", fieldName, beanName));
    }

    private static void checkInteger(Integer fieldValue, Field field, String beanName) throws BeanMisconfiguredException {
        if (field.isAnnotationPresent(NonNegative.class) && fieldValue < 0) {
            HelperCheckMisconfigured.generateNonNegativeException(field.getName(), beanName);
        }
        if (field.isAnnotationPresent(Positive.class) && fieldValue <= 0) {
            HelperCheckMisconfigured.generatePositiveException(field.getName(), beanName);
        }
    }

    private static void checkShort(Short fieldValue, Field field, String beanName) throws BeanMisconfiguredException {
        if (field.isAnnotationPresent(NonNegative.class) && fieldValue < 0) {
            HelperCheckMisconfigured.generateNonNegativeException(field.getName(), beanName);
        }
        if (field.isAnnotationPresent(Positive.class) && fieldValue <= 0) {
            HelperCheckMisconfigured.generatePositiveException(field.getName(), beanName);
        }
    }

    private static void checkDouble(Double fieldValue, Field field, String beanName) throws BeanMisconfiguredException {
        if (field.isAnnotationPresent(NonNegative.class) && fieldValue < 0.0) {
            HelperCheckMisconfigured.generateNonNegativeException(field.getName(), beanName);
        }
        if (field.isAnnotationPresent(Positive.class) && fieldValue <= 0.0) {
            HelperCheckMisconfigured.generatePositiveException(field.getName(), beanName);
        }
    }

    private static void checkFloat(Float fieldValue, Field field, String beanName) throws BeanMisconfiguredException {
        if (field.isAnnotationPresent(NonNegative.class) && fieldValue.floatValue() < 0.0f) {
            HelperCheckMisconfigured.generateNonNegativeException(field.getName(), beanName);
        }
        if (field.isAnnotationPresent(Positive.class) && fieldValue.floatValue() <= 0.0f) {
            HelperCheckMisconfigured.generatePositiveException(field.getName(), beanName);
        }
    }

    private static void checkLong(Long fieldValue, Field field, String beanName) throws BeanMisconfiguredException {
        if (field.isAnnotationPresent(NonNegative.class) && fieldValue < 0L) {
            HelperCheckMisconfigured.generateNonNegativeException(field.getName(), beanName);
        }
        if (field.isAnnotationPresent(Positive.class) && fieldValue <= 0L) {
            HelperCheckMisconfigured.generatePositiveException(field.getName(), beanName);
        }
    }
}

