/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.bean;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.anchoranalysis.bean.AnchorBean;
import org.anchoranalysis.bean.FieldAccessor;
import org.anchoranalysis.bean.exception.BeanDuplicateException;
import org.anchoranalysis.bean.exception.BeanMisconfiguredException;
import org.anchoranalysis.bean.primitive.StringSet;
import org.apache.commons.lang3.ClassUtils;

class HelperDuplication {
    public static <T> AnchorBean<T> duplicate(AnchorBean<T> bean) {
        try {
            AnchorBean beanOut = (AnchorBean)bean.getClass().getConstructor(new Class[0]).newInstance(new Object[0]);
            for (Field field : bean.fields()) {
                Optional<Object> propertyNew = HelperDuplication.duplicatePropertyValue(Optional.ofNullable(field.get(bean)), field.getName(), FieldAccessor.isFieldAnnotatedAsOptional(field), beanOut);
                if (!propertyNew.isPresent()) continue;
                field.set(beanOut, propertyNew.get());
            }
            Optional<Path> localPath = bean.getLocalPath();
            if (localPath.isPresent()) {
                beanOut.localise(localPath.get());
            }
            return beanOut;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException | BeanMisconfiguredException e) {
            throw new BeanDuplicateException((Throwable)e);
        }
    }

    private static Object duplicateCollection(Collection<?> collection, String propertyName, AnchorBean<?> parentBean) {
        Stream<Optional> stream = collection.stream().map(object -> HelperDuplication.duplicatePropertyValue(Optional.ofNullable(object), propertyName, false, parentBean));
        return stream.filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    private static Optional<Object> duplicatePropertyValue(Optional<Object> propertyValue, String propertyName, boolean optional, AnchorBean<?> parentBean) {
        if (!propertyValue.isPresent()) {
            if (optional) {
                return Optional.empty();
            }
            throw new BeanDuplicateException(String.format("Property '%s' of '%s' is null, but non-optional", propertyName, parentBean.getBeanName()));
        }
        return HelperDuplication.duplicatePropertyValue(propertyValue.get(), propertyName, parentBean);
    }

    private static Optional<Object> duplicatePropertyValue(Object propertyValue, String propertyName, AnchorBean<?> parentBean) {
        if (propertyValue instanceof StringSet) {
            StringSet propertyValueCast = (StringSet)propertyValue;
            return Optional.of(propertyValueCast.duplicateBean());
        }
        if (propertyValue instanceof AnchorBean) {
            AnchorBean propertyValueCast = (AnchorBean)propertyValue;
            return Optional.of(propertyValueCast.duplicateBean());
        }
        if (propertyValue instanceof Collection) {
            return Optional.of(HelperDuplication.duplicateCollection((Collection)propertyValue, propertyName, parentBean));
        }
        if (HelperDuplication.isImmutableType(propertyValue.getClass())) {
            return Optional.of(propertyValue);
        }
        throw new BeanDuplicateException(String.format("Unsupported property type: %s", propertyValue.getClass().toString()));
    }

    private static boolean isImmutableType(Class<?> cls) {
        if (String.class.isAssignableFrom(cls)) {
            return true;
        }
        if (Class.class.isAssignableFrom(cls)) {
            return true;
        }
        return ClassUtils.isPrimitiveOrWrapper(cls);
    }

    private HelperDuplication() {
    }
}

