/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.bean.define;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.anchoranalysis.bean.AnchorBean;
import org.anchoranalysis.bean.NamedBean;
import org.anchoranalysis.bean.annotation.GroupingRoot;
import org.anchoranalysis.bean.define.DefineAddException;
import org.anchoranalysis.core.exception.friendly.AnchorImpossibleSituationException;
import org.anchoranalysis.core.functional.FunctionalList;

public class Define
extends AnchorBean<Define> {
    private Map<Class<?>, List<NamedBean<?>>> map = new HashMap();

    public void add(NamedBean<?> bean) throws DefineAddException {
        Class<?> itemType = bean.getItem().getClass();
        Class<?> groupingRoot = Define.findGroupingRoot(itemType);
        this.listForGroup(groupingRoot).add(bean);
    }

    public void addAll(Define source) {
        for (Class<?> key : source.keySet()) {
            try {
                List list = source.listFor(key);
                this.addAll(list);
            }
            catch (DefineAddException e) {
                throw new AnchorImpossibleSituationException();
            }
        }
    }

    public <T extends AnchorBean<?>> void addAll(List<NamedBean<T>> list) throws DefineAddException {
        for (NamedBean<T> bean : list) {
            this.add(bean);
        }
    }

    public <T extends AnchorBean<?>> List<NamedBean<T>> listFor(Class<?> groupingRoot) {
        List<NamedBean<?>> list = this.map.get(groupingRoot);
        if (list == null) {
            return Arrays.asList(new NamedBean[0]);
        }
        return FunctionalList.mapToList(list, NamedBean.class::cast);
    }

    @Override
    public Define duplicateBean() {
        Define out = new Define();
        for (Map.Entry<Class<?>, List<NamedBean<?>>> entry : this.map.entrySet()) {
            out.map.put(entry.getKey(), Define.duplicateList(entry.getValue()));
        }
        return out;
    }

    private Set<Class<?>> keySet() {
        return this.map.keySet();
    }

    private List<NamedBean<?>> listForGroup(Class<?> groupingRoot) {
        return this.map.computeIfAbsent(groupingRoot, key -> new ArrayList());
    }

    private static List<NamedBean<?>> duplicateList(List<NamedBean<?>> in) {
        return FunctionalList.mapToList(in, AnchorBean::duplicateBean);
    }

    private static Class<?> findGroupingRoot(Class<?> leaf) throws DefineAddException {
        Class<?> consider = leaf;
        do {
            if (!consider.isAnnotationPresent(GroupingRoot.class)) continue;
            return consider;
        } while ((consider = consider.getSuperclass()) != null);
        throw new DefineAddException(String.format("Bean-class %s is missing a groupingRoot. This must exist in the class-hierarchy for any item in a NamedDefinitions", leaf));
    }
}

