/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.bean.initializable;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.anchoranalysis.bean.AnchorBean;
import org.anchoranalysis.bean.initializable.BeanAndParent;
import org.anchoranalysis.bean.initializable.FindChildrenForInit;
import org.anchoranalysis.bean.initializable.InitializableBean;
import org.anchoranalysis.bean.initializable.property.BeanInitializer;
import org.anchoranalysis.core.exception.InitializeException;
import org.anchoranalysis.core.log.Logger;

class HelperInit {
    public static void initializeRecursive(AnchorBean<?> bean, BeanInitializer<?> initializer, Logger logger) throws InitializeException {
        LinkedList<BeanAndParent> everything = new LinkedList<BeanAndParent>();
        everything.add(new BeanAndParent(bean, null));
        HashSet done = new HashSet();
        while (!everything.isEmpty()) {
            BeanAndParent removedObj = (BeanAndParent)everything.remove(everything.size() - 1);
            if (done.contains(removedObj.getBean())) continue;
            HelperInit.maybeInitializeChildren(removedObj, everything, bean.getBeanName(), initializer, logger);
            done.add(removedObj.getBean());
        }
    }

    private static void maybeInitializeChildren(BeanAndParent bean, List<BeanAndParent> listInit, String beanNameFollowingFrom, BeanInitializer<?> propertyInitializer, Logger logger) throws InitializeException {
        try {
            boolean didInitChild = propertyInitializer.applyInitializationIfPossibleTo(bean.getBean(), bean.parentBean(), logger);
            if (didInitChild) {
                FindChildrenForInit.addChildrenFromBean(bean, listInit);
            } else {
                HelperInit.throwExceptionIfInitializable(bean.getBean(), beanNameFollowingFrom, propertyInitializer.getInitializationType().toString());
            }
        }
        catch (InitializeException e) {
            String msg = String.format("Cannot initialize a field '%s' when initializing '%s'", bean.pathFromRootAsString(), beanNameFollowingFrom);
            throw new InitializeException(msg, (Throwable)e);
        }
    }

    private static void throwExceptionIfInitializable(AnchorBean<?> bean, String beanNameFollowingFrom, String provider) throws InitializeException {
        if (bean instanceof InitializableBean) {
            InitializableBean beanCast = (InitializableBean)bean;
            throw new InitializeException(String.format("Could not find matching parameters to initialize %s (%s) (recursively following from %s). Requires %s. Provider is %s.", beanCast.getBeanName(), beanCast.getClass().getName(), beanNameFollowingFrom, beanCast.getPropertyInitializer().describeAcceptedClasses(), provider));
        }
    }

    private HelperInit() {
    }
}

