/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.bean.initializable.property;

import org.anchoranalysis.bean.initializable.InitializableBean;
import org.anchoranalysis.bean.initializable.parameters.BeanInitialization;
import org.anchoranalysis.bean.initializable.property.InitializationParameterAssigner;
import org.anchoranalysis.core.exception.InitializeException;
import org.anchoranalysis.core.log.Logger;

public class AssignerMatchClass<P extends BeanInitialization>
implements InitializationParameterAssigner {
    private final Class<?> paramTypeMatch;

    @Override
    public boolean accepts(Class<?> paramType) {
        return this.paramTypeMatch.isAssignableFrom(paramType);
    }

    @Override
    public void assignInitializationToProperties(Object bean, Object initialization, Object parent, Logger logger) throws InitializeException {
        if (!(bean instanceof InitializableBean)) {
            throw new InitializeException(String.format("propertyValue is not an instance of %s, as is required for this property-definer", InitializableBean.class.getSimpleName()));
        }
        if (!this.paramTypeMatch.isAssignableFrom(initialization.getClass())) {
            throw new InitializeException(String.format("param is not the same class or a subclass of %s, as is required for this property-definer", this.paramTypeMatch.getSimpleName()));
        }
        InitializableBean propertyValueCast = (InitializableBean)bean;
        propertyValueCast.initialize((BeanInitialization)initialization, logger);
    }

    public String toString() {
        return String.format("assignableFrom=%s", this.paramTypeMatch);
    }

    @Override
    public String describeAcceptedClasses() {
        return this.paramTypeMatch.getSimpleName();
    }

    public AssignerMatchClass(Class<?> paramTypeMatch) {
        this.paramTypeMatch = paramTypeMatch;
    }
}

