/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.bean.initializable.property;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.anchoranalysis.bean.initializable.InitializableBean;
import org.anchoranalysis.bean.initializable.parameters.NullInitialization;
import org.anchoranalysis.bean.initializable.property.ExtractDerivedParameter;
import org.anchoranalysis.bean.initializable.property.InitializationParameterAssigner;
import org.anchoranalysis.core.exception.InitializeException;
import org.anchoranalysis.core.functional.OptionalFactory;
import org.anchoranalysis.core.log.Logger;

public class BeanInitializer<P> {
    private P initializationParam;
    private final Class<?> initializationType;
    private List<ExtractDerivedParameter<P, ?>> extracters = this.listExtractersWithDefault();

    public BeanInitializer(Class<?> initializationType) {
        this.initializationType = initializationType;
    }

    public BeanInitializer(Class<?> initializationType, List<ExtractDerivedParameter<P, ?>> extractersToAdd) {
        this.initializationType = initializationType;
        this.extracters.addAll(extractersToAdd);
    }

    public void setParam(P param) {
        this.initializationParam = param;
    }

    public boolean applyInitializationIfPossibleTo(Object bean, Object parent, Logger logger) throws InitializeException {
        assert (this.initializationParam != null);
        if (this.initializeIdenticalParamTypes(bean, parent, logger)) {
            return true;
        }
        return this.initializeExtractedParameters(bean, parent, logger);
    }

    private boolean initializeIdenticalParamTypes(Object bean, Object parent, Logger logger) throws InitializeException {
        return this.initializationParam != null && this.initializeMatchingPropertiesWith(bean, parent, logger, this.initializationParam.getClass(), this.initializationParam);
    }

    private boolean initializeExtractedParameters(Object bean, Object parent, Logger logger) throws InitializeException {
        for (ExtractDerivedParameter<P, ?> extract : this.extracters) {
            Optional<?> extractedParam = extract.extractIfPossible(this.initializationParam);
            if (!extractedParam.isPresent() || !this.initializeMatchingPropertiesWith(bean, parent, logger, extract.getTargetClass(), extractedParam.get())) continue;
            return true;
        }
        return false;
    }

    private boolean initializeMatchingPropertiesWith(Object bean, Object parent, Logger logger, Class<?> propertyClassToMatch, Object paramToInitWith) throws InitializeException {
        Optional<InitializationParameterAssigner> property = this.areParametersAccepted(bean, propertyClassToMatch);
        if (property.isPresent()) {
            property.get().assignInitializationToProperties(bean, paramToInitWith, parent, logger);
            return true;
        }
        return false;
    }

    private Optional<InitializationParameterAssigner> areParametersAccepted(Object bean, Class<?> paramType) {
        if (bean instanceof InitializableBean) {
            InitializableBean initBean = (InitializableBean)bean;
            InitializationParameterAssigner initializer = initBean.getPropertyInitializer();
            return OptionalFactory.create((boolean)initializer.accepts(paramType), (Object)initializer);
        }
        return Optional.empty();
    }

    private List<ExtractDerivedParameter<P, ?>> listExtractersWithDefault() {
        ArrayList list = new ArrayList();
        list.add(this.nullExtracter());
        return list;
    }

    private ExtractDerivedParameter<P, NullInitialization> nullExtracter() {
        return new ExtractDerivedParameter<Object, NullInitialization>(NullInitialization.class, parameters -> NullInitialization.instance());
    }

    public Class<?> getInitializationType() {
        return this.initializationType;
    }
}

