/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.bean.initializable.property;

import java.util.Optional;
import java.util.function.Function;

public class ExtractDerivedParameter<S, T> {
    private Class<?> targetClass;
    private Function<S, T> extractionFunction;
    private Optional<Class<?>> sourceBaseClass;

    public ExtractDerivedParameter(Class<?> targetClass, Function<S, T> extractionFunction) {
        this.targetClass = targetClass;
        this.extractionFunction = extractionFunction;
        this.sourceBaseClass = Optional.empty();
    }

    public ExtractDerivedParameter(Class<?> targetClass, Function<S, T> extractionFunction, Class<?> sourceBaseClass) {
        this.targetClass = targetClass;
        this.extractionFunction = extractionFunction;
        this.sourceBaseClass = Optional.of(sourceBaseClass);
    }

    public Optional<T> extractIfPossible(S parameter) {
        if (this.accepts(parameter.getClass())) {
            return Optional.of(this.extract(parameter));
        }
        return Optional.empty();
    }

    private boolean accepts(Class<?> paramClass) {
        if (this.sourceBaseClass.isPresent()) {
            return this.sourceBaseClass.get().isAssignableFrom(paramClass.getClass());
        }
        return true;
    }

    private T extract(S parameter) {
        return this.extractionFunction.apply(parameter);
    }

    public Class<?> getTargetClass() {
        return this.targetClass;
    }
}

