/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.bean.permute;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.anchoranalysis.bean.AnchorBean;
import org.anchoranalysis.bean.exception.BeanDuplicateException;
import org.anchoranalysis.bean.permute.assign.AssignPermutationException;
import org.anchoranalysis.bean.permute.assign.PermutationAssigner;
import org.anchoranalysis.bean.permute.property.PermuteProperty;
import org.anchoranalysis.core.exception.CreateException;

public class PermutedCopyCreator<T extends AnchorBean<T>> {
    private final Function<T, String> nameGetter;
    private final BiConsumer<T, String> nameSetter;

    public <S> List<T> createPermutedCopies(List<T> beans, PermuteProperty<S> propertyToPermute, PermutationAssigner setter) throws CreateException {
        ArrayList<AnchorBean> out = new ArrayList<AnchorBean>();
        try {
            for (AnchorBean bean : beans) {
                Iterator<S> valuesToPermute = propertyToPermute.propertyValues();
                if (!valuesToPermute.hasNext()) {
                    throw new CreateException("No values exist to assign during permutation.");
                }
                while (valuesToPermute.hasNext()) {
                    out.add(this.copyAndAssignValue(bean, valuesToPermute.next(), propertyToPermute, setter));
                }
            }
            return out;
        }
        catch (IllegalArgumentException | BeanDuplicateException | AssignPermutationException e) {
            throw new CreateException((Throwable)e);
        }
    }

    private <S> T copyAndAssignValue(T bean, S valueToAssign, PermuteProperty<S> propertyToPermute, PermutationAssigner setter) throws AssignPermutationException {
        AnchorBean duplicated = (AnchorBean)((AnchorBean)bean).duplicateBean();
        setter.assignValue(duplicated, valueToAssign);
        this.assignUpdatedName(duplicated, propertyToPermute, valueToAssign);
        return (T)duplicated;
    }

    private <S> void assignUpdatedName(T feature, PermuteProperty<S> permute, S propVal) {
        String nameNew = this.sensibleName(feature, permute, propVal);
        this.nameSetter.accept(feature, nameNew);
    }

    private <S> String sensibleName(T feature, PermuteProperty<S> permute, S propVal) {
        String toAppend = permute.describePropertyValue(propVal);
        String exsting = this.nameGetter.apply(feature);
        if (!exsting.isEmpty()) {
            return String.format("%s.%s", exsting, toAppend);
        }
        return toAppend;
    }

    public PermutedCopyCreator(Function<T, String> nameGetter, BiConsumer<T, String> nameSetter) {
        this.nameGetter = nameGetter;
        this.nameSetter = nameSetter;
    }
}

